package ru.yandex.direct.grid.processing.service.showcondition.bids;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdSetAutoBids;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdSetAutoBidsPayload;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdSetBids;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdSetBidsPayload;

/**
 * Сервис, для обновления ставок
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class BidsGraphQlService {

    private final BidsDataService bidsDataService;

    @Autowired
    public BidsGraphQlService(BidsDataService bidsDataService) {
        this.bidsDataService = bidsDataService;
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "setAutoBids")
    public GdSetAutoBidsPayload setAutoBids(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdSetAutoBids input) {
        return bidsDataService.setAutoBids(input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "setBids")
    public GdSetBidsPayload setBids(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdSetBids input) {
        return bidsDataService.setBids(input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "setBidsRetargeting")
    public GdSetBidsPayload setBidsRetargeting(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdSetBids input) {
        return bidsDataService.setBidsRetargeting(input);
    }
}
