package ru.yandex.direct.grid.processing.service.showcondition.converter;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.advq.query.ast.Word;
import ru.yandex.advq.query.ast.WordKind;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdAddKeywordsOperatorsMode;
import ru.yandex.direct.libs.keywordutils.model.AnyKeyword;
import ru.yandex.direct.libs.keywordutils.model.Keyword;
import ru.yandex.direct.libs.keywordutils.model.OrderedKeyword;
import ru.yandex.direct.libs.keywordutils.model.SingleKeyword;

import static ru.yandex.direct.grid.processing.model.showcondition.mutation.GdAddKeywordsOperatorsMode.FORM;
import static ru.yandex.direct.grid.processing.model.showcondition.mutation.GdAddKeywordsOperatorsMode.NUMBER;
import static ru.yandex.direct.grid.processing.model.showcondition.mutation.GdAddKeywordsOperatorsMode.ORDER;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class KeywordOperatorsConverter {

    /**
     * Преобразовывает {@link Keyword} ключевые фразы добавляя операторы в зависимости от списка
     * {@link GdAddKeywordsOperatorsMode} требуемых операторов
     * GdAddKeywordsOperatorsMode.NUMBER - "зафиксировать количество слов"
     * GdAddKeywordsOperatorsMode.FORM - !зафиксировать !форму !слов
     * GdAddKeywordsOperatorsMode.ORDER - [зафиксировать порядок слов]
     */
    public Keyword addOperators(Keyword keyword, List<GdAddKeywordsOperatorsMode> operators) {
        boolean changed = false;
        if (operators.contains(NUMBER) && !keyword.isQuoted()) {
            keyword = new Keyword(true, keyword.getAllKeywords());
            changed = true;
        }
        if (operators.contains(FORM)) {
            var fixed = fixForm(keyword.getAllKeywords());
            if (fixed != null) {
                keyword = new Keyword(keyword.isQuoted(), fixed);
                changed = true;
            }
        }
        if (operators.contains(ORDER)) {
            if (keyword.getAllKeywords().stream().allMatch(s -> s instanceof SingleKeyword)) {
                List<SingleKeyword> singleKeywords = mapList(keyword.getAllKeywords(), s -> (SingleKeyword) s);
                keyword = new Keyword(keyword.isQuoted(), List.of(new OrderedKeyword(singleKeywords)));
                changed = true;
            }
        }
        return changed ? keyword : null;
    }

    @Nullable
    private List<AnyKeyword> fixForm(List<AnyKeyword> allKeywords) {
        List<AnyKeyword> fixedKeywords = new ArrayList<>();
        boolean changed = false;
        for (AnyKeyword keyword : allKeywords) {
            if (keyword instanceof OrderedKeyword) {
                List<SingleKeyword> singleKeywords = ((OrderedKeyword) keyword).getSingleKeywords();
                List<SingleKeyword> newKeywords = new ArrayList<>();
                for (SingleKeyword singleKeyword : singleKeywords) {
                    if (singleKeyword.getWord().getKind() == WordKind.RAW) {
                        newKeywords.add(new SingleKeyword(new Word(WordKind.FIXED, singleKeyword.getWord().getText())));
                        changed = true;
                    } else {
                        newKeywords.add(singleKeyword);
                    }
                }
                fixedKeywords.add(new OrderedKeyword(newKeywords));
            } else {
                if (((SingleKeyword) keyword).getWord().getKind() == WordKind.RAW) {
                    fixedKeywords.add(new SingleKeyword(new Word(WordKind.FIXED,
                            ((SingleKeyword) keyword).getWord().getText())));
                    changed = true;
                } else {
                    fixedKeywords.add(keyword);
                }
            }
        }
        return changed ? fixedKeywords : null;
    }

}
