package ru.yandex.direct.grid.processing.service.showcondition.converter;

import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.advq.search.Statistics;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdBulkRefineKeywords;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdBulkRefineKeywordsWithMinuses;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdRefineKeyword;
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdRefineKeywordWithMinuses;

@ParametersAreNonnullByDefault
public class RefineWordConverter {
    private RefineWordConverter() {
    }

    /**
     * Преобразовать запрос для одной фразы в запрос для нескольких фраз.
     */
    public static GdBulkRefineKeywords convertToBulk(GdRefineKeyword request) {
        return new GdBulkRefineKeywords()
                .withKeywords(Collections.singletonList(request.getKeyword()))
                .withGeo(request.getGeo())
                .withMinusWords(request.getMinusWords())
                .withAdGroupType(request.getAdGroupType());
    }

    /**
     * Преобразовать запрос для одной фразы в запрос для нескольких фраз.
     */
    public static GdBulkRefineKeywordsWithMinuses convertToBulk(GdRefineKeywordWithMinuses request) {
        return new GdBulkRefineKeywordsWithMinuses()
                .withKeywords(Collections.singletonList(request.getKeyword()))
                .withGeo(request.getGeo())
                .withMinusWords(request.getMinusWords())
                .withAdGroupType(request.getAdGroupType())
                .withAdGroupId(request.getAdGroupId())
                .withAdGroupMinusKeywordPackIds(request.getAdGroupMinusKeywordPackIds())
                .withCampaignId(request.getCampaignId())
                .withCampaignMinusKeywordPackIds(request.getCampaignMinusKeywordPackIds());
    }

    /**
     * Костыль для отдачи статистики по Коллекциям - в среднем колдунщик коллекций показывается 1 на 10 показов серпа,
     * поэтому для коллекций берём стандартный прогноз и делим на 10 с округлением вверх. См. DIRECT-112021
     * @param statistics  Статистика, полученная для серпа.
     * @param adGroupType Тип группы, для которой вычисляли статистику.
     * @return Если статистика вычислялась для Коллекций, возвращает исходную статистику, поделённую на 10;
     * иначе возвращает исходную статистику.
     * @see ru.yandex.direct.web.entity.keyword.stat.service.KeywordStatShowsConverter#countShows(long, GdAdGroupType)
     */
    public static Statistics fixStatisticsForContentPromotionCollections(
            Statistics statistics, GdAdGroupType adGroupType) {
        if (adGroupType != GdAdGroupType.CONTENT_PROMOTION_COLLECTION) {
            return statistics;
        }
        statistics.setTotalCount(countContentPromotionCollectionCnt(statistics.getTotalCount()));
        if (statistics.getAssociations() != null) {
            StreamEx.of(statistics.getAssociations())
                    .forEach(phraseItem -> phraseItem.setCnt(countContentPromotionCollectionCnt(phraseItem.getCnt())));
        }
        if (statistics.getIncludingPhrases() != null) {
            StreamEx.of(statistics.getIncludingPhrases())
                    .forEach(phraseItem -> phraseItem.setCnt(countContentPromotionCollectionCnt(phraseItem.getCnt())));
        }
        return statistics;
    }

    /**
     * Делим на 10 с округлением вверх.
     */
    private static long countContentPromotionCollectionCnt(long currentCnt) {
        return (currentCnt + 9) / 10;
    }
}
