package ru.yandex.direct.grid.processing.service.showcondition.converter;

import java.util.List;
import java.util.function.Function;

import javax.annotation.Nullable;

import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.common.GdResult;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdCreateRetargetingConditionForExperimentsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdCreateRetargetingConditionPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdDeleteRetargetingConditionsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdDeleteRetargetingsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdResumeRetargetingsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdSuspendRetargetingsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdUpdateRetargetingConditionPayloadItem;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.result.Result;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;

public class RetargetingMutationConverter {

    public static <T> GdResult<T> convertToGdResult(Integer totalCount, MassResult<Long> result,
                                                    @Nullable GdValidationResult vr,
                                                    Function<Result<Long>, T> massResultConverter) {
        List<T> rowset = filterAndMapList(result.getResult(), Result::isSuccessful,
                massResultConverter);

        return new GdResult<T>()
                .withSuccessCount(result.getSuccessfulObjectsCount())
                .withTotalCount(totalCount)
                .withRowset(rowset)
                .withValidationResult(vr);
    }

    public static <T> GdResult<T> convertToGdResult(Integer totalCount, List<T> rowset,
                                                    @Nullable GdValidationResult vr) {
        return new GdResult<T>()
                .withSuccessCount(rowset.size())
                .withTotalCount(totalCount)
                .withRowset(rowset)
                .withValidationResult(vr);
    }

    public static GdCreateRetargetingConditionPayloadItem toCreateRetargetingConditionRowset(Result<Long> result) {
        return new GdCreateRetargetingConditionPayloadItem()
                .withRetargetingConditionId(result.getResult());
    }


    public static GdCreateRetargetingConditionPayloadItem toCreateRetargetingConditionRowset(Long addedId) {
        return new GdCreateRetargetingConditionPayloadItem()
                .withRetargetingConditionId(addedId);
    }

    public static GdUpdateRetargetingConditionPayloadItem toUpdateRetargetingConditionRowset(Result<Long> result) {
        return new GdUpdateRetargetingConditionPayloadItem()
                .withRetargetingConditionId(result.getResult());
    }

    public static GdDeleteRetargetingConditionsPayloadItem toDeleteRetargetingConditionRowset(Result<Long> result) {
        return new GdDeleteRetargetingConditionsPayloadItem()
                .withRetargetingConditionsId(result.getResult());
    }

    public static GdResumeRetargetingsPayloadItem toResumeRetargetingRowset(Result<Long> result) {
        return new GdResumeRetargetingsPayloadItem()
                .withRetargetingId(result.getResult());
    }

    public static GdSuspendRetargetingsPayloadItem toSuspendRetargetingRowset(Result<Long> result) {
        return new GdSuspendRetargetingsPayloadItem()
                .withRetargetingId(result.getResult());
    }

    public static GdDeleteRetargetingsPayloadItem toDeleteRetargetingRowset(Result<Long> result) {
        return new GdDeleteRetargetingsPayloadItem()
                .withRetargetingId(result.getResult());
    }

    public static GdCreateRetargetingConditionForExperimentsPayloadItem toGdCreateRetargetingConditionForExperimentsPayloadItem(
            Long statisticRetargetingConditionId, Long retargetingConditionId) {
        return new GdCreateRetargetingConditionForExperimentsPayloadItem()
                .withStatisticRetargetingConditionId(statisticRetargetingConditionId)
                .withRetargetingConditionId(retargetingConditionId);
    }
}
