package ru.yandex.direct.grid.processing.service.showcondition.converter;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.model.campaign.GdCampaignPlatform;
import ru.yandex.direct.grid.model.campaign.GdCampaignType;
import ru.yandex.direct.grid.processing.model.showcondition.GdKeyword;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowCondition;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionFeatures;
import ru.yandex.direct.grid.processing.util.AggregationStatsCalculator;

@ParametersAreNonnullByDefault
class ShowConditionFeatureCalculator {

    static final AggregationStatsCalculator<GdShowCondition, GdShowConditionFeatures> FEATURE_CALCULATOR =
            AggregationStatsCalculator.<GdShowCondition, GdShowConditionFeatures>builder(GdShowConditionFeatures::new)
                    .hasValue(GdShowConditionFeatures::setHasPrice, hasNonNullField(GdKeyword::getPrice))
                    .hasValue(GdShowConditionFeatures::setHasPriceContext,
                            hasNonNullField(GdKeyword::getPriceContext))
                    .hasValue(GdShowConditionFeatures::setHasAutobudgetPriority,
                            hasNonNullField(GdKeyword::getAutobudgetPriority))
                    .valuesSet(GdShowConditionFeatures::setCommonPlatform, getPlatform())
                    .valuesSet(GdShowConditionFeatures::setCommonCampaignTypes, getCampaignTypes())
                    .build();

    private ShowConditionFeatureCalculator() {
    }

    private static Function<GdShowCondition, Boolean> hasNonNullField(Function<GdKeyword, ?> getter) {
        return showCondition -> showCondition instanceof GdKeyword && getter.apply((GdKeyword) showCondition) != null;
    }

    private static Function<GdShowCondition, GdCampaignPlatform> getPlatform() {
        return showCondition -> showCondition.getAdGroup().getCampaign().getFlatStrategy().getPlatform();
    }

    private static Function<GdShowCondition, GdCampaignType> getCampaignTypes() {
        return showCondition -> showCondition.getAdGroup().getCampaign().getType();
    }
}
