package ru.yandex.direct.grid.processing.service.showcondition.converter;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Значения категорий в том виде, в котором они используются в апи
 */
public enum TargetingCategory {
    UNDEFINED,
    EXACT,
    ALTERNATIVE,
    COMPETITOR,
    BROADER,
    ACCESSORY;

    @JsonProperty
    public String getStringValue() {
        return name().toLowerCase();
    }

    public static TargetingCategory fromStringValue(String targetingCategory) {
        return valueOf(targetingCategory.toUpperCase());
    }
}
