package ru.yandex.direct.grid.processing.service.showcondition.searchQueries

import org.springframework.beans.factory.annotation.Value
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.campaign.container.CampaignNewMinusKeywords
import ru.yandex.direct.core.entity.campaign.service.CampaignService
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository
import ru.yandex.direct.core.entity.uac.grut.GrutTransactionProvider
import ru.yandex.direct.core.entity.uac.service.GrutUacCampaignService
import ru.yandex.direct.core.entity.user.model.User
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdMoveSearchQueriesToMinusKeywords
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdMoveToMinusKeywords
import ru.yandex.direct.grid.processing.model.showcondition.mutation.GdMoveToMinusKeywordsPayload
import ru.yandex.direct.grid.processing.service.showcondition.keywords.KeywordsDataService
import ru.yandex.direct.grid.processing.service.showcondition.validation.ShowConditionValidationService

@Service
class SearchQueriesDataService(
    private val grutUacCampaignService: GrutUacCampaignService,
    private val grutTransactionProvider: GrutTransactionProvider,
    private val campaignService: CampaignService,
    private val keywordRepository: KeywordRepository,
    private val keywordsDataService: KeywordsDataService,
    private val showConditionValidationService: ShowConditionValidationService,
    @Value("\${object_api.retries}") private val grutRetries: Int
) {
    fun moveToMinusKeywords(
        subjectUser: User,
        operator: User,
        request: GdMoveSearchQueriesToMinusKeywords
    ): GdMoveToMinusKeywordsPayload {
        val keywords = listOf(request.searchQuery)
        val keywordIdByPhrase = keywordRepository.getKeywordIdByPhrase(
            keywords, request.campaignId, subjectUser.clientId
        )

        if (keywordIdByPhrase.isNotEmpty()) {
            return keywordsDataService.moveToMinusKeywords(
                GdMoveToMinusKeywords()
                    .withKeywordIds(keywordIdByPhrase.values.toList())
            )
        }

        val appendMinusKeywordsOperation = campaignService.createAppendMinusKeywordsOperation(
            listOf(CampaignNewMinusKeywords(request.campaignId, keywords)),
            operator.uid,
            subjectUser.clientId
        )

        val appendMinusKeywordsResult = appendMinusKeywordsOperation.prepareAndApply()
        if (appendMinusKeywordsResult.validationResult.hasAnyErrors()) {
            val appendMinusKeywordsVr = showConditionValidationService
                .getValidationResultForRequestWithSearchQuery(appendMinusKeywordsResult.validationResult)

            return GdMoveToMinusKeywordsPayload()
                .withMovedKeywordIds(listOf())
                .withValidationResult(appendMinusKeywordsVr)
        }

        grutTransactionProvider.runInRetryableTransaction<Any?>(grutRetries, null) {
            grutUacCampaignService.deleteCampaignKeywordsAndAppendMinusKeywords(
                mapOf(), mapOf(request.campaignId to keywords)
            )
            null
        }

        return GdMoveToMinusKeywordsPayload()
            .withMovedKeywordIds(listOf())
    }
}
