package ru.yandex.direct.grid.processing.service.smartfilter.converter;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilter;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.smartfilter.mutation.GdDeleteSmartFilter;
import ru.yandex.direct.grid.processing.model.smartfilter.mutation.GdUpdateSmartFiltersItem;
import ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService;
import ru.yandex.direct.grid.processing.service.validation.presentation.SkipByDefaultMappingPathNodeConverter;
import ru.yandex.direct.validation.result.DefaultPathNodeConverterProvider;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.validation.result.PathHelper.field;
import static ru.yandex.direct.validation.result.PathHelper.path;

public class GdDeleteSmartFiltersConverter {


    private static final PathNodeConverterProvider PATH_NODE_CONVERTER_PROVIDER;

    static {
        SkipByDefaultMappingPathNodeConverter.Builder builder = SkipByDefaultMappingPathNodeConverter.builder();
        PerformanceFilter.allModelProperties()
                .forEach(modelProperty -> builder.replace(modelProperty.name(), GdUpdateSmartFiltersItem.ID.name()));
        PATH_NODE_CONVERTER_PROVIDER =
                DefaultPathNodeConverterProvider.builder()
                        .register(PerformanceFilter.class, builder.build())
                        .build();
    }

    @Nullable
    public static GdValidationResult toGdValidationResult(ValidationResult<?, Defect> vr) {
        if (hasValidationIssues(vr)) {
            return GridValidationResultConversionService
                    .buildGridValidationResult(vr, path(field(GdDeleteSmartFilter.DELETE_ITEMS)),
                            PATH_NODE_CONVERTER_PROVIDER);
        }
        return null;
    }

}
