package ru.yandex.direct.grid.processing.service.smartfilter.loader;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import one.util.streamex.StreamEx;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.campaign.GdCampaignTruncated;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClientInfo;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupTruncated;
import ru.yandex.direct.grid.processing.model.smartfilter.GdSmartFilter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignInfoService;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;
import ru.yandex.direct.grid.processing.service.group.GroupDataService;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class AdGroupBySmartFilterDataLoader extends GridBatchingDataLoader<GdSmartFilter, GdAdGroupTruncated> {
    public AdGroupBySmartFilterDataLoader(
            GridContextProvider gridContextProvider,
            CampaignInfoService campaignInfoService,
            GroupDataService groupDataService
    ) {
        dataLoader = mappedDataLoader(gridContextProvider, (filters, environment) -> {
            GridGraphQLContext context = environment.getContext();
            GdClientInfo client = context.getQueriedClient();

            ClientId clientId = ClientId.fromLong(client.getId());
            Set<Long> campaignIds = listToSet(filters, GdSmartFilter::getCampaignId);
            Map<Long, GdCampaignTruncated> campaignsById =
                    campaignInfoService.getTruncatedCampaigns(clientId, campaignIds);

            Set<Long> adGroupIds = listToSet(filters, GdSmartFilter::getAdGroupId);
            List<GdAdGroupTruncated> groups =
                    groupDataService.getTruncatedAdGroups(client.getShard(), client.getCountryRegionId(),
                            clientId, context.getOperator(), adGroupIds, campaignsById);

            Map<Long, GdAdGroupTruncated> groupsById =
                    listToMap(groups, GdAdGroupTruncated::getId);
            Map<GdSmartFilter, GdAdGroupTruncated> result = StreamEx.of(filters)
                    .mapToEntry(GdSmartFilter::getAdGroupId)
                    .mapValues(groupsById::get)
                    .toMap();

            return CompletableFuture.completedFuture(result);
        });
    }
}
