package ru.yandex.direct.grid.processing.service.statistics;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.grid.processing.model.statistics.GdCampaignStatisticsColumnValues;
import ru.yandex.direct.grid.processing.model.statistics.GdCampaignStatisticsItem;
import ru.yandex.direct.grid.processing.model.statistics.GdCampaignStatisticsValueHolder;
import ru.yandex.direct.grid.processing.model.statistics.GdStatisticsAgeType;
import ru.yandex.direct.grid.processing.model.statistics.GdStatisticsDeviceType;
import ru.yandex.direct.grid.processing.model.statistics.GdStatisticsGenderType;
import ru.yandex.direct.intapi.client.model.response.statistics.CampaignStatisticsItem;

import static ru.yandex.direct.utils.CommonUtils.nullableNvl;

@Component
@ParametersAreNonnullByDefault
public class CampaignStatisticsConverter {

    @Autowired
    public CampaignStatisticsConverter() {
    }

    public List<GdCampaignStatisticsItem> convert(List<CampaignStatisticsItem> campaignStatisticsItems) {
        return StreamEx.of(campaignStatisticsItems)
                .map(this::convert)
                .toList();
    }

    public GdCampaignStatisticsItem convert(CampaignStatisticsItem campaignStatisticsItem) {
        return new GdCampaignStatisticsItem()
                .withAge(GdStatisticsAgeType.fromSource(campaignStatisticsItem.getAgeType()))
                .withGender(GdStatisticsGenderType.fromSource(campaignStatisticsItem.getGenderType()))
                .withDate(campaignStatisticsItem.getDate())
                .withEndDate(campaignStatisticsItem.getEndDate())
                .withRegion(campaignStatisticsItem.getRegion())
                .withBid(campaignStatisticsItem.getBid())
                .withDeviceType(GdStatisticsDeviceType.fromSource(campaignStatisticsItem.getDeviceType()))
                .withSearchQuery(campaignStatisticsItem.getSearchQuery())
                .withColumnValues(convertColumnValues(campaignStatisticsItem));
    }

    public GdCampaignStatisticsColumnValues convertColumnValues(CampaignStatisticsItem campaignStatisticsItem) {
        return new GdCampaignStatisticsColumnValues()
                .withAvgNShow(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getAvgNShow(),
                                        campaignStatisticsItem.getAvgNShowA()))
                                .withValueToCompare(campaignStatisticsItem.getAvgNShowB())
                                .withValuePrcDelta(campaignStatisticsItem.getAvgNShowDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getAvgNShowAbsDelta()))
                .withAvgNShowComplete(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getAvgNShowComplete(),
                                        campaignStatisticsItem.getAvgNShowCompleteA()))
                                .withValueToCompare(campaignStatisticsItem.getAvgNShowCompleteB())
                                .withValuePrcDelta(campaignStatisticsItem.getAvgNShowCompleteDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getAvgNShowCompleteAbsDelta()))
                .withClicks(new GdCampaignStatisticsValueHolder()
                        .withValue(nullableNvl(campaignStatisticsItem.getClicks(), campaignStatisticsItem.getClicksA()))
                        .withValueToCompare(campaignStatisticsItem.getClicksB())
                        .withValuePrcDelta(campaignStatisticsItem.getClicksPctDelta())
                        .withValueAbsDelta(campaignStatisticsItem.getClicksAbsDelta()))
                .withShows(new GdCampaignStatisticsValueHolder()
                        .withValue(nullableNvl(campaignStatisticsItem.getShows(), campaignStatisticsItem.getShowsA()))
                        .withValueToCompare(campaignStatisticsItem.getShowsB())
                        .withValuePrcDelta(campaignStatisticsItem.getShowsPctDelta())
                        .withValueAbsDelta(campaignStatisticsItem.getShowsAbsDelta()))
                .withConversions(new GdCampaignStatisticsValueHolder()
                        .withValue(nullableNvl(campaignStatisticsItem.getConversions(),
                                campaignStatisticsItem.getConversionsA()))
                        .withValueToCompare(campaignStatisticsItem.getConversionsB())
                        .withValuePrcDelta(campaignStatisticsItem.getConversionsPctDelta())
                        .withValueAbsDelta(campaignStatisticsItem.getConversionsAbsDelta()))
                .withAvgCpc(new GdCampaignStatisticsValueHolder()
                        .withValue(nullableNvl(campaignStatisticsItem.getAvgCpc(),
                                campaignStatisticsItem.getAvgCpcA()))
                        .withValueToCompare(campaignStatisticsItem.getAvgCpcB())
                        .withValuePrcDelta(campaignStatisticsItem.getAvgCpcPctDelta())
                        .withValueAbsDelta(campaignStatisticsItem.getAvgCpcAbsDelta()))
                .withCostPerConversion(new GdCampaignStatisticsValueHolder()
                        .withValue(nullableNvl(campaignStatisticsItem.getCostPerConversion(),
                                campaignStatisticsItem.getCostPerConversionA()))
                        .withValueToCompare(campaignStatisticsItem.getCostPerConversionB())
                        .withValuePrcDelta(campaignStatisticsItem.getCostPerConversionPctDelta())
                        .withValueAbsDelta(campaignStatisticsItem.getCostPerConversionAbsDelta()))
                .withCost(new GdCampaignStatisticsValueHolder()
                        .withValue(nullableNvl(campaignStatisticsItem.getCost(), campaignStatisticsItem.getCostA()))
                        .withValueToCompare(campaignStatisticsItem.getCostB())
                        .withValuePrcDelta(campaignStatisticsItem.getCostPctDelta())
                        .withValueAbsDelta(campaignStatisticsItem.getCostAbsDelta()))
                .withRevenue(new GdCampaignStatisticsValueHolder()
                        .withValue(nullableNvl(campaignStatisticsItem.getRevenue(),
                                campaignStatisticsItem.getRevenueA()))
                        .withValueToCompare(campaignStatisticsItem.getRevenueB())
                        .withValuePrcDelta(campaignStatisticsItem.getRevenuePctDelta())
                        .withValueAbsDelta(campaignStatisticsItem.getRevenueAbsDelta()))
                .withAvgCpm(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getAvgCpm(),
                                        campaignStatisticsItem.getAvgCpmA()))
                                .withValueToCompare(campaignStatisticsItem.getAvgCpmB())
                                .withValuePrcDelta(campaignStatisticsItem.getAvgCpmPctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getAvgCpmAbsDelta()))
                .withVideoTrueView(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getVideoTrueView(),
                                        campaignStatisticsItem.getVideoTrueViewA()))
                                .withValueToCompare(campaignStatisticsItem.getVideoTrueViewB())
                                .withValuePrcDelta(campaignStatisticsItem.getVideoTrueViewPctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getVideoTrueViewAbsDelta()))
                .withUniqViewers(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getUniqViewers(),
                                        campaignStatisticsItem.getUniqViewersA()))
                                .withValueToCompare(campaignStatisticsItem.getUniqViewersB())
                                .withValuePrcDelta(campaignStatisticsItem.getUniqViewersPctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getUniqViewersAbsDelta()))
                .withAvgViewFreq(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getAvgViewFreq(),
                                        campaignStatisticsItem.getAvgViewFreqA()))
                                .withValueToCompare(campaignStatisticsItem.getAvgViewFreqB())
                                .withValuePrcDelta(campaignStatisticsItem.getAvgViewFreqPctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getAvgViewFreqAbsDelta()))
                .withCtr(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getCtr(),
                                        campaignStatisticsItem.getCtrA()))
                                .withValueToCompare(campaignStatisticsItem.getCtrB())
                                .withValuePrcDelta(campaignStatisticsItem.getCtrPctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getCtrAbsDelta()))
                .withVideoAvgTrueViewCost(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getVideoAvgTrueViewCost(),
                                        campaignStatisticsItem.getVideoAvgTrueViewCostA()))
                                .withValueToCompare(campaignStatisticsItem.getVideoAvgTrueViewCostB())
                                .withValuePrcDelta(campaignStatisticsItem.getVideoAvgTrueViewCostPctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getVideoAvgTrueViewCostAbsDelta()))
                .withVideoFirstQuartileRate(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getVideoFirstQuartileRate(),
                                        campaignStatisticsItem.getVideoFirstQuartileRateA()))
                                .withValueToCompare(campaignStatisticsItem.getVideoFirstQuartileRateB())
                                .withValuePrcDelta(campaignStatisticsItem.getVideoFirstQuartileRatePctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getVideoFirstQuartileRateAbsDelta()))
                .withVideoMidpointRate(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getVideoMidpointRate(),
                                        campaignStatisticsItem.getVideoMidpointRateA()))
                                .withValueToCompare(campaignStatisticsItem.getVideoMidpointRateB())
                                .withValuePrcDelta(campaignStatisticsItem.getVideoMidpointRatePctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getVideoMidpointRateAbsDelta()))
                .withVideoThirdQuartileRate(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getVideoThirdQuartileRate(),
                                        campaignStatisticsItem.getVideoThirdQuartileRateA()))
                                .withValueToCompare(campaignStatisticsItem.getVideoThirdQuartileRateB())
                                .withValuePrcDelta(campaignStatisticsItem.getVideoThirdQuartileRatePctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getVideoThirdQuartileRateAbsDelta()))
                .withVideoCompleteRate(
                        new GdCampaignStatisticsValueHolder()
                                .withValue(nullableNvl(campaignStatisticsItem.getVideoCompleteRate(),
                                        campaignStatisticsItem.getVideoCompleteRateA()))
                                .withValueToCompare(campaignStatisticsItem.getVideoCompleteRateB())
                                .withValuePrcDelta(campaignStatisticsItem.getVideoCompleteRatePctDelta())
                                .withValueAbsDelta(campaignStatisticsItem.getVideoCompleteRateAbsDelta()))

                ;
    }
}
