package ru.yandex.direct.grid.processing.service.statistics.utils;

import java.util.Set;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.uac.model.TargetType;
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class UacCampaignContext {

    private static final long INSTALL_CLICK_GOAL_ID = 4L;
    private static final long INSTALL_SHOW_GOAL_ID = 8L;
    private static final long INSTALL_IOS14_GOAL_ID = 10L;

    private final long goalClickId;
    private final long goalViewId;
    private final long installsGoalClickId;
    private final long installsGoalViewId;
    private final boolean hasImpressionUrl;

    private final Set<Long> goalIds;

    public UacCampaignContext(UacYdbCampaign uacCampaign) {
        this.goalClickId = getGoalId(uacCampaign.getTargetId(), uacCampaign, true);
        this.goalViewId = getGoalId(uacCampaign.getTargetId(), uacCampaign, false);
        this.installsGoalClickId = getGoalId(TargetType.INSTALL, uacCampaign, true);
        this.installsGoalViewId = getGoalId(TargetType.INSTALL, uacCampaign, false);
        this.hasImpressionUrl = uacCampaign.getImpressionUrl() != null;

        this.goalIds = StreamEx.of(goalClickId, goalViewId, installsGoalClickId, installsGoalViewId)
                .toSet();
    }

    private long getGoalId(TargetType targetType,
                           UacYdbCampaign uacCampaign,
                           boolean isClickGoal) {
        if (targetType != TargetType.INSTALL) {
            return targetType.getGoalId();
        }

        if (nvl(uacCampaign.getSkadNetworkEnabled(), false)) {
            return INSTALL_IOS14_GOAL_ID;
        }

        return isClickGoal ? INSTALL_CLICK_GOAL_ID : INSTALL_SHOW_GOAL_ID;
    }

    public long getGoalClickId() {
        return goalClickId;
    }

    public long getGoalViewId() {
        return goalViewId;
    }

    public long getInstallsGoalClickId() {
        return installsGoalClickId;
    }

    public long getInstallsGoalViewId() {
        return installsGoalViewId;
    }

    public boolean hasImpressionUrl() {
        return hasImpressionUrl;
    }

    public Set<Long> getGoalIds() {
        return goalIds;
    }
}
