package ru.yandex.direct.grid.processing.service.strategy.mutation

import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgClick
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpa
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerCamp
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerCamp
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpv
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpvCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressions
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressionsCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReach
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReachCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMedia
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekSum
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.model.CpmDefault
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.model.PeriodFixBid
import ru.yandex.direct.core.entity.strategy.model.StrategyAttributionModel
import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.grid.model.campaign.GdMeaningfulGoal
import ru.yandex.direct.grid.model.strategy.GdStrategyAttributionModel
import ru.yandex.direct.grid.model.strategy.GdStrategyAttributionModelConverter
import ru.yandex.direct.grid.model.strategy.GdStrategyDayBudgetShowMode
import ru.yandex.direct.grid.model.strategy.GdStrategyDayBudgetShowModeConverter
import ru.yandex.direct.grid.model.strategy.GdStrategyName
import ru.yandex.direct.grid.model.strategy.GdStrategyNameConverter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgClick
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpa
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpaPerCamp
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpaPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpcPerCamp
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpcPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpi
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpv
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpvCustomPeriod
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetCrr
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetMaxImpressions
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetMaxImpressionsCustomPeriod
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetMaxReach
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetMaxReachCustomPeriod
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetMedia
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetRoi
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetWeekBundle
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetWeekSum
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddCpmDefault
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddDefaultManualStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddPackageStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddPackageStrategyUnion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddPeriodFixBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgCpa
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgCpm
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgCpv
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithCustomPeriodBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithDayBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithMeaningfulGoals
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithMetrikaCounters
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithPayForConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithWeeklyBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgClick
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpa
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpaPerCamp
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpaPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpcPerCamp
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpcPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpi
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpv
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpvCustomPeriod
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetCrr
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetMaxImpressions
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetMaxImpressionsCustomPeriod
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetMaxReach
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetMaxReachCustomPeriod
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetMedia
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetRoi
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetWeekBundle
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetWeekSum
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateCpmDefault
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateDefaultManualStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategyUnion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePeriodFixBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgCpa
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgCpm
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgCpv
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithCustomPeriodBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithDayBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithMeaningfulGoals
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithMetrikaCounters
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithPayForConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithWeeklyBudget
import ru.yandex.direct.model.ModelChanges

object PackageStrategyConverter {

    fun toStrategy(strategy: GdAddPackageStrategy): CommonStrategy? {
        val instance = when (strategy) {
            is GdAddAutobudgetWeekSum ->
                AutobudgetWeekSum()
            is GdAddDefaultManualStrategy ->
                DefaultManualStrategy()
                    .withEnableCpcHold(strategy.enableCpcHold)
            is GdAddCpmDefault ->
                CpmDefault()
            is GdAddAutobudgetAvgCpvCustomPeriod ->
                AutobudgetAvgCpvCustomPeriod()
            is GdAddAutobudgetAvgCpv ->
                AutobudgetAvgCpv()
            is GdAddAutobudgetCrr ->
                AutobudgetCrr()
                    .withCrr(strategy.crr)
            is GdAddAutobudgetAvgCpaPerCamp ->
                AutobudgetAvgCpaPerCamp()
            is GdAddAutobudgetAvgCpaPerFilter ->
                AutobudgetAvgCpaPerFilter()
                    .withFilterAvgCpa(strategy.filterAvgCpa)
            is GdAddAutobudgetAvgCpa ->
                AutobudgetAvgCpa()
            is GdAddAutobudgetAvgCpi ->
                AutobudgetAvgCpi()
                    .withAvgCpi(strategy.avgCpi)
            is GdAddAutobudgetRoi ->
                AutobudgetRoi()
                    .withReserveReturn(strategy.reserveReturn)
                    .withRoiCoef(strategy.roiCoef)
                    .withProfitability(strategy.profitability)
            is GdAddAutobudgetAvgClick ->
                AutobudgetAvgClick()
            is GdAddAutobudgetAvgCpcPerCamp ->
                AutobudgetAvgCpcPerCamp()
            is GdAddAutobudgetAvgCpcPerFilter ->
                AutobudgetAvgCpcPerFilter()
                    .withFilterAvgBid(strategy.filterAvgBid)
            is GdAddAutobudgetMaxImpressions ->
                AutobudgetMaxImpressions()
            is GdAddAutobudgetMaxImpressionsCustomPeriod ->
                AutobudgetMaxImpressionsCustomPeriod()
            is GdAddAutobudgetMaxReach ->
                AutobudgetMaxReach()
            is GdAddAutobudgetMaxReachCustomPeriod ->
                AutobudgetMaxReachCustomPeriod()
            is GdAddAutobudgetMedia ->
                AutobudgetMedia()
                    .withDate(strategy.date)
            is GdAddAutobudgetWeekBundle ->
                AutobudgetWeekBundle()
                    .withLimitClicks(strategy.limitClicks)
            is GdAddPeriodFixBid ->
                PeriodFixBid()
            //CommonStrategy is not sealed interface
            else -> null
        }
        return instance?.let {
            fillCommon(it, strategy)
            fillMetrikaCounters(it, strategy)
            fillAvgBid(it, strategy)
            fillAvgCpa(it, strategy)
            fillAvgCpm(it, strategy)
            fillAvgCpv(it, strategy)
            fillBid(it, strategy)
            fillStrategyWithConversion(it, strategy)
            fillCustomPeriodBudget(it, strategy)
            fillDayBudget(it, strategy)
            fillMeaningfulGoals(it, strategy)
            fillPayForConversion(it, strategy)
            fillWeeklyBudget(it, strategy)
        }
    }

    fun toGdUpdatePackageStrategy(union: GdUpdatePackageStrategyUnion): GdUpdatePackageStrategy {
        return GdUpdatePackageStrategyUnion.allModelProperties()
            .mapNotNull { it.getRaw(union) as? GdUpdatePackageStrategy }
            .firstOrNull() ?: throw IllegalArgumentException("Expect one of update package strategy")
    }

    fun toGdAddPackageStrategy(union: GdAddPackageStrategyUnion): GdAddPackageStrategy {
        return GdAddPackageStrategyUnion.allModelProperties()
            .mapNotNull { it.getRaw(union) as? GdAddPackageStrategy }
            .firstOrNull() ?: throw IllegalArgumentException("Expect one of add package strategy")
    }

    private fun toStrategyName(type: GdStrategyName?): StrategyName? =
        GdStrategyNameConverter.toSource(type)

    fun toModelChanges(strategy: GdUpdatePackageStrategy): ModelChanges<out CommonStrategy>? {
        val changes = when (strategy) {
            is GdUpdateAutobudgetWeekSum ->
                toAutobudgetWeekSum(strategy)
            is GdUpdateDefaultManualStrategy ->
                toDefaultManualStrategy(strategy)
            is GdUpdateCpmDefault ->
                toCpmDefault(strategy)
            is GdUpdateAutobudgetAvgCpvCustomPeriod ->
                toAutobudgetAvgCpvCustomPeriod(strategy)
            is GdUpdateAutobudgetAvgCpv ->
                toAutobudgetAvgCpv(strategy)
            is GdUpdateAutobudgetCrr ->
                toAutobudgetCrr(strategy)
            is GdUpdateAutobudgetAvgCpaPerCamp ->
                toAutobudgetAvgCpaPerCamp(strategy)
            is GdUpdateAutobudgetAvgCpaPerFilter ->
                toAutobudgetAvgCpaPerFilter(strategy)
            is GdUpdateAutobudgetAvgCpa ->
                toAutobudgetAvgCpa(strategy)
            is GdUpdateAutobudgetAvgCpi ->
                toAutobudgetAvgCpi(strategy)
            is GdUpdateAutobudgetRoi ->
                toAutobudgetRoi(strategy)
            is GdUpdateAutobudgetAvgClick ->
                toAutobudgetAvgClick(strategy)
            is GdUpdateAutobudgetAvgCpcPerCamp ->
                toAutobudgetAvgCpcPerCamp(strategy)
            is GdUpdateAutobudgetAvgCpcPerFilter ->
                toAutobudgetAvgCpcPerFilter(strategy)
            is GdUpdateAutobudgetMaxImpressions ->
                toAutobudgetMaxImpressions(strategy)
            is GdUpdateAutobudgetMaxImpressionsCustomPeriod ->
                toAutobudgetMaxImpressionsCustomPeriod(strategy)
            is GdUpdateAutobudgetMaxReach ->
                toAutobudgetMaxReach(strategy)
            is GdUpdateAutobudgetMaxReachCustomPeriod ->
                toAutobudgetMaxReachCustomPeriod(strategy)
            is GdUpdateAutobudgetMedia ->
                toAutobudgetMedia(strategy)
            is GdUpdateAutobudgetWeekBundle ->
                toAutobudgetWeekBundle(strategy)
            is GdUpdatePeriodFixBid ->
                toPeriodFixBid(strategy)
            //CommonStrategy is not sealed interface
            else -> null
        }
        return changes?.let { fillCommon(it, strategy) }
    }

    private fun toAttributionModel(attributionModel: GdStrategyAttributionModel?): StrategyAttributionModel? =
        GdStrategyAttributionModelConverter.toSource(attributionModel)

    private fun toDayBudgetShowMode(showMode: GdStrategyDayBudgetShowMode?): StrategyDayBudgetShowMode? =
        GdStrategyDayBudgetShowModeConverter.toSource(showMode)

    private fun fillCommon(
        changes: ModelChanges<out CommonStrategy>,
        updateStrategy: GdUpdatePackageStrategy
    ): ModelChanges<out CommonStrategy> =
        changes
            .process(toStrategyName(updateStrategy.type), CommonStrategy.TYPE)
            .process(toAttributionModel(updateStrategy.attributionModel), CommonStrategy.ATTRIBUTION_MODEL)
            .process(updateStrategy.cids, CommonStrategy.CIDS)
            .process(toStrategyName(updateStrategy.type), CommonStrategy.TYPE)
            .process(updateStrategy.isPublic, CommonStrategy.IS_PUBLIC)
            .process(updateStrategy.name, CommonStrategy.NAME)

    private fun toAutobudgetWeekSum(updateStrategy: GdUpdateAutobudgetWeekSum): ModelChanges<AutobudgetWeekSum> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetWeekSum::class.java)
        fillMetrikaCounters(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillStrategyWithConversion(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toDefaultManualStrategy(updateStrategy: GdUpdateDefaultManualStrategy): ModelChanges<DefaultManualStrategy> {
        val changes = ModelChanges(updateStrategy.id, DefaultManualStrategy::class.java)
            .process(updateStrategy.enableCpcHold, DefaultManualStrategy.ENABLE_CPC_HOLD)

        fillMetrikaCounters(changes, updateStrategy)
        fillDayBudget(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        return changes
    }

    private fun toCpmDefault(updateStrategy: GdUpdateCpmDefault): ModelChanges<CpmDefault> {
        val changes = ModelChanges(updateStrategy.id, CpmDefault::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillDayBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpvCustomPeriod(updateStrategy: GdUpdateAutobudgetAvgCpvCustomPeriod): ModelChanges<AutobudgetAvgCpvCustomPeriod> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpvCustomPeriod::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpv(changes, updateStrategy)
        fillCustomPeriodBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpv(updateStrategy: GdUpdateAutobudgetAvgCpv): ModelChanges<AutobudgetAvgCpv> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpv::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpv(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetCrr(updateStrategy: GdUpdateAutobudgetCrr): ModelChanges<AutobudgetCrr> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetCrr::class.java)
            .process(updateStrategy.crr, AutobudgetCrr.CRR)

        fillMetrikaCounters(changes, updateStrategy)
        fillStrategyWithConversion(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillPayForConversion(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpaPerCamp(updateStrategy: GdUpdateAutobudgetAvgCpaPerCamp): ModelChanges<AutobudgetAvgCpaPerCamp> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpaPerCamp::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpa(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillStrategyWithConversion(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillPayForConversion(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpaPerFilter(updateStrategy: GdUpdateAutobudgetAvgCpaPerFilter): ModelChanges<AutobudgetAvgCpaPerFilter> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpaPerFilter::class.java)
            .process(updateStrategy.filterAvgCpa, AutobudgetAvgCpaPerFilter.FILTER_AVG_CPA)

        fillMetrikaCounters(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillStrategyWithConversion(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillPayForConversion(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpa(updateStrategy: GdUpdateAutobudgetAvgCpa): ModelChanges<AutobudgetAvgCpa> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpa::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpa(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillStrategyWithConversion(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillPayForConversion(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpi(updateStrategy: GdUpdateAutobudgetAvgCpi): ModelChanges<AutobudgetAvgCpi> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpi::class.java)
            .process(updateStrategy.avgCpi, AutobudgetAvgCpi.AVG_CPI)

        fillBid(changes, updateStrategy)
        fillStrategyWithConversion(changes, updateStrategy)
        fillPayForConversion(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetRoi(updateStrategy: GdUpdateAutobudgetRoi): ModelChanges<AutobudgetRoi> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetRoi::class.java)
            .process(updateStrategy.roiCoef, AutobudgetRoi.ROI_COEF)
            .process(updateStrategy.reserveReturn, AutobudgetRoi.RESERVE_RETURN)
            .process(updateStrategy.profitability, AutobudgetRoi.PROFITABILITY)

        fillMetrikaCounters(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillStrategyWithConversion(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgClick(updateStrategy: GdUpdateAutobudgetAvgClick): ModelChanges<AutobudgetAvgClick> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgClick::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgBid(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpcPerCamp(updateStrategy: GdUpdateAutobudgetAvgCpcPerCamp): ModelChanges<AutobudgetAvgCpcPerCamp> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpcPerCamp::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgBid(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetAvgCpcPerFilter(updateStrategy: GdUpdateAutobudgetAvgCpcPerFilter): ModelChanges<AutobudgetAvgCpcPerFilter> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetAvgCpcPerFilter::class.java)
            .process(updateStrategy.filterAvgBid, AutobudgetAvgCpcPerFilter.FILTER_AVG_BID)

        fillMetrikaCounters(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetMaxImpressions(updateStrategy: GdUpdateAutobudgetMaxImpressions): ModelChanges<AutobudgetMaxImpressions> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetMaxImpressions::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpm(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetMaxImpressionsCustomPeriod(updateStrategy: GdUpdateAutobudgetMaxImpressionsCustomPeriod): ModelChanges<AutobudgetMaxImpressionsCustomPeriod> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetMaxImpressionsCustomPeriod::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpm(changes, updateStrategy)
        fillCustomPeriodBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetMaxReach(updateStrategy: GdUpdateAutobudgetMaxReach): ModelChanges<AutobudgetMaxReach> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetMaxReach::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpm(changes, updateStrategy)
        fillWeeklyBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetMaxReachCustomPeriod(updateStrategy: GdUpdateAutobudgetMaxReachCustomPeriod): ModelChanges<AutobudgetMaxReachCustomPeriod> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetMaxReachCustomPeriod::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgCpm(changes, updateStrategy)
        fillCustomPeriodBudget(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetMedia(updateStrategy: GdUpdateAutobudgetMedia): ModelChanges<AutobudgetMedia> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetMedia::class.java)
            .process(updateStrategy.date, AutobudgetMedia.DATE)

        fillMetrikaCounters(changes, updateStrategy)
        return changes
    }

    private fun toAutobudgetWeekBundle(updateStrategy: GdUpdateAutobudgetWeekBundle): ModelChanges<AutobudgetWeekBundle> {
        val changes = ModelChanges(updateStrategy.id, AutobudgetWeekBundle::class.java)
            .process(updateStrategy.limitClicks, AutobudgetWeekBundle.LIMIT_CLICKS)

        fillMetrikaCounters(changes, updateStrategy)
        fillAvgBid(changes, updateStrategy)
        fillBid(changes, updateStrategy)
        fillMeaningfulGoals(changes, updateStrategy)
        return changes
    }

    private fun toPeriodFixBid(updateStrategy: GdUpdatePeriodFixBid): ModelChanges<PeriodFixBid> {
        val changes = ModelChanges(updateStrategy.id, PeriodFixBid::class.java)

        fillMetrikaCounters(changes, updateStrategy)
        fillCustomPeriodBudget(changes, updateStrategy)
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithMetrikaCounters> fillMetrikaCounters(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithMetrikaCounters) {
            changes.process(updateStrategy.metrikaCounters, StrategyWithMetrikaCounters.METRIKA_COUNTERS)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithAvgBid> fillAvgBid(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithAvgBid) {
            changes.process(updateStrategy.avgBid, StrategyWithAvgBid.AVG_BID)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithAvgCpa> fillAvgCpa(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithAvgCpa) {
            changes.process(updateStrategy.avgCpa, StrategyWithAvgCpa.AVG_CPA)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithAvgCpm> fillAvgCpm(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithAvgCpm) {
            changes.process(updateStrategy.avgCpm, StrategyWithAvgCpm.AVG_CPM)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithAvgCpv> fillAvgCpv(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithAvgCpv) {
            changes.process(updateStrategy.avgCpv, StrategyWithAvgCpv.AVG_CPV)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithBid> fillBid(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithBid) {
            changes.process(updateStrategy.bid, StrategyWithBid.BID)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithConversion> fillStrategyWithConversion(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithConversion) {
            changes.process(updateStrategy.goalId, StrategyWithConversion.GOAL_ID)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithCustomPeriodBudget> fillCustomPeriodBudget(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithCustomPeriodBudget) {
            changes.process(updateStrategy.start, StrategyWithCustomPeriodBudget.START)
            changes.process(updateStrategy.finish, StrategyWithCustomPeriodBudget.FINISH)
            changes.process(updateStrategy.autoProlongation, StrategyWithCustomPeriodBudget.AUTO_PROLONGATION)
            changes.process(updateStrategy.budget, StrategyWithCustomPeriodBudget.BUDGET)
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithDayBudget> fillDayBudget(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithDayBudget) {
            changes.process(updateStrategy.dayBudget, StrategyWithDayBudget.DAY_BUDGET)
            changes.process(
                toDayBudgetShowMode(updateStrategy.dayBudgetShowMode),
                StrategyWithDayBudget.DAY_BUDGET_SHOW_MODE
            )
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithMeaningfulGoals> fillMeaningfulGoals(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithMeaningfulGoals) {
            changes.process(
                toMeaningfulGoals(updateStrategy.meaningfulGoals),
                StrategyWithMeaningfulGoals.MEANINGFUL_GOALS
            )
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithPayForConversion> fillPayForConversion(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithPayForConversion) {
            changes.process(
                updateStrategy.isPayForConversionEnabled,
                StrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED
            )
        }
        return changes
    }

    private fun <T : GdUpdatePackageStrategy, M : StrategyWithWeeklyBudget> fillWeeklyBudget(
        changes: ModelChanges<M>,
        updateStrategy: T
    ): ModelChanges<M> {
        if (updateStrategy is GdUpdateStrategyWithWeeklyBudget) {
            changes.process(updateStrategy.sum, StrategyWithWeeklyBudget.SUM)
        }
        return changes
    }

    private fun toMeaningfulGoals(goals: List<GdMeaningfulGoal>?): List<MeaningfulGoal>? =
        goals?.map { goal ->
            MeaningfulGoal()
                .withGoalId(goal.goalId)
                .withConversionValue(goal.conversionValue)
                .withIsMetrikaSourceOfValue(goal.isMetrikaSourceOfValue)
        }

    private fun fillCommon(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        instance.type = toStrategyName(addStrategy.type)
        instance.attributionModel = toAttributionModel(addStrategy.attributionModel)
        instance.cids = addStrategy.cids
        instance.name = addStrategy.name
        instance.isPublic = addStrategy.isPublic
        return instance
    }

    private fun fillMetrikaCounters(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithMetrikaCounters && instance is StrategyWithMetrikaCounters) {
            instance.metrikaCounters = addStrategy.metrikaCounters
        }
        return instance
    }

    private fun fillAvgBid(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithAvgBid && instance is StrategyWithAvgBid) {
            instance.avgBid = addStrategy.avgBid
        }
        return instance
    }

    private fun fillAvgCpa(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithAvgCpa && instance is StrategyWithAvgCpa) {
            instance.avgCpa = addStrategy.avgCpa
        }
        return instance
    }

    private fun fillAvgCpm(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithAvgCpm && instance is StrategyWithAvgCpm) {
            instance.avgCpm = addStrategy.avgCpm
        }
        return instance
    }

    private fun fillAvgCpv(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithAvgCpv && instance is StrategyWithAvgCpv) {
            instance.avgCpv = addStrategy.avgCpv
        }
        return instance
    }

    private fun fillBid(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithBid && instance is StrategyWithBid) {
            instance.bid = addStrategy.bid
        }
        return instance
    }

    private fun fillStrategyWithConversion(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithConversion && instance is StrategyWithConversion) {
            instance.goalId = addStrategy.goalId
        }
        return instance
    }

    private fun fillCustomPeriodBudget(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithCustomPeriodBudget && instance is StrategyWithCustomPeriodBudget) {
            instance.start = addStrategy.start
            instance.finish = addStrategy.finish
            instance.autoProlongation = addStrategy.autoProlongation
            instance.budget = addStrategy.budget
        }
        return instance
    }

    private fun fillDayBudget(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithDayBudget && instance is StrategyWithDayBudget) {
            instance.dayBudget = addStrategy.dayBudget
            instance.dayBudgetShowMode = toDayBudgetShowMode(addStrategy.dayBudgetShowMode)
        }
        return instance
    }

    private fun fillMeaningfulGoals(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithMeaningfulGoals && instance is StrategyWithMeaningfulGoals) {
            instance.meaningfulGoals = toMeaningfulGoals(addStrategy.meaningfulGoals)
        }
        return instance
    }

    private fun fillPayForConversion(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithPayForConversion && instance is StrategyWithPayForConversion) {
            instance.isPayForConversionEnabled = addStrategy.isPayForConversionEnabled
        }
        return instance
    }

    private fun fillWeeklyBudget(
        instance: CommonStrategy,
        addStrategy: GdAddPackageStrategy
    ): CommonStrategy {
        if (addStrategy is GdAddStrategyWithWeeklyBudget && instance is StrategyWithWeeklyBudget) {
            instance.sum = addStrategy.sum
        }
        return instance
    }
}
