package ru.yandex.direct.grid.processing.service.strategy.mutation.add

import io.leangen.graphql.annotations.GraphQLArgument
import io.leangen.graphql.annotations.GraphQLMutation
import io.leangen.graphql.annotations.GraphQLRootContext
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite
import ru.yandex.direct.grid.processing.annotations.EnableLoggingOnValidationIssues
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddPackageStrategies
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddPackageStrategyPayload
import ru.yandex.direct.grid.processing.service.strategy.mutation.PackageStrategyMutationService
import java.util.concurrent.CompletableFuture

@GridGraphQLService
class PackageStrategyAddGraphQlService(
    private val packageStrategyMutationService: PackageStrategyMutationService
) {

    companion object {
        private const val ADD_STRATEGIES = "addStrategies"
    }

    @PreAuthorizeWrite
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = ADD_STRATEGIES)
    fun updateStrategies(
        @GraphQLRootContext context: GridGraphQLContext,
        @GraphQLArgument(name = "input") input: GdAddPackageStrategies
    ): CompletableFuture<GdAddPackageStrategyPayload> {
        return CompletableFuture.completedFuture(packageStrategyMutationService.addPackageStrategies(input, context))
    }
}
