package ru.yandex.direct.grid.processing.service.strategy.mutation.update

import io.leangen.graphql.annotations.GraphQLArgument
import io.leangen.graphql.annotations.GraphQLMutation
import io.leangen.graphql.annotations.GraphQLRootContext
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite
import ru.yandex.direct.grid.processing.annotations.EnableLoggingOnValidationIssues
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUnbindedCampaigns
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategies
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategiesStatusArchive
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategiesStatusArchivePayload
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategyPayload
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategyiesUnbindCampaigns
import ru.yandex.direct.grid.processing.service.strategy.mutation.PackageStrategyCampaignUnbindService
import ru.yandex.direct.grid.processing.service.strategy.mutation.PackageStrategyMutationService
import java.util.concurrent.CompletableFuture

@GridGraphQLService
class PackageStrategyUpdateGraphQlService(
    val packageStrategyMutationService: PackageStrategyMutationService,
    val packageStrategyCampaignUnbindService: PackageStrategyCampaignUnbindService
) {

    companion object {
        const val UPDATE_STRATEGIES = "updateStrategies"
        const val UPDATE_STRATEGIES_STATUS_ARCHIVE = "updateStrategiesStatusArchive"
        const val UNBIND_CAMPAIGNS = "unbindCampaigns"
    }

    @PreAuthorizeWrite
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = UPDATE_STRATEGIES)
    fun updateStrategies(
        @GraphQLRootContext context: GridGraphQLContext,
        @GraphQLArgument(name = "input") input: GdUpdatePackageStrategies
    ): CompletableFuture<GdUpdatePackageStrategyPayload> {
        return CompletableFuture.completedFuture(packageStrategyMutationService.updateStrategies(context, input))
    }

    @PreAuthorizeWrite
    @GraphQLMutation(name = UPDATE_STRATEGIES_STATUS_ARCHIVE)
    fun updateStrategiesStatusArchive(
        @GraphQLRootContext context: GridGraphQLContext,
      @GraphQLArgument(name = "input") input: GdUpdatePackageStrategiesStatusArchive
    ): CompletableFuture<GdUpdatePackageStrategiesStatusArchivePayload> = CompletableFuture.completedFuture(
        packageStrategyMutationService.changeStrategiesArchiveStatus(context, input)
    )

    @PreAuthorizeWrite
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = UNBIND_CAMPAIGNS)
    fun unbindCampaigns(
        @GraphQLRootContext context: GridGraphQLContext,
        @GraphQLArgument(name = "input") input: GdUpdatePackageStrategyiesUnbindCampaigns
    ): CompletableFuture<GdUnbindedCampaigns> {
        return CompletableFuture.completedFuture(packageStrategyCampaignUnbindService.unbind(context, input))
    }
}
