package ru.yandex.direct.grid.processing.service.strategy.mutation.validation

import org.springframework.stereotype.Service
import ru.yandex.direct.grid.processing.model.api.GdValidationResult
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddPackageStrategies
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategies
import ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService
import ru.yandex.direct.grid.processing.service.validation.GridValidationService
import ru.yandex.direct.result.MassResult
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.Path
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

@Service
class PackageStrategiesValidationService(private val gridValidationService: GridValidationService) {

    fun getValidationResult(massResult: MassResult<Long>, path: Path): GdValidationResult? =
        GridValidationResultConversionService
            .buildGridValidationResultIfErrors(
                massResult.validationResult,
                path,
                PackageStrategyPathConverters.pathNodeConverterProvider
            )

    fun validateUpdatePackageStrategies(input: GdUpdatePackageStrategies) =
        gridValidationService.applyValidator(GdUpdatePackageStrategiesValidator, input, false)

    fun getAddValidationResult(massResult: MassResult<Long>, path: Path): GdValidationResult? =
        GridValidationResultConversionService
            .buildGridValidationResultIfErrors(
                massResult.validationResult,
                path,
                PackageStrategyPathConverters.addPathNodeConverterProvider
            )

    fun validateAddPackageStrategies(input: GdAddPackageStrategies) =
        gridValidationService.applyValidator(GdAddPackageStrategiesValidator, input, false)

    companion object {
        object GdUpdatePackageStrategiesValidator : Validator<GdUpdatePackageStrategies?, Defect<*>> {
            override fun apply(t: GdUpdatePackageStrategies?): ValidationResult<GdUpdatePackageStrategies?, Defect<*>> {
                val vb = ModelItemValidationBuilder.of(t)
                vb.check(notNull())
                vb.item(GdUpdatePackageStrategies.STRATEGY_UPDATE_ITEMS)
                    .check(notNull())
                    .check(notEmptyCollection(), When.isValid())
                return vb.result
            }
        }

        object GdAddPackageStrategiesValidator : Validator<GdAddPackageStrategies?, Defect<*>> {
            override fun apply(t: GdAddPackageStrategies?): ValidationResult<GdAddPackageStrategies?, Defect<*>> {
                return ValidationResult.success(t)
            }
        }
    }
}
