package ru.yandex.direct.grid.processing.service.strategy.mutation.validation

import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgClick
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpa
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerCamp
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerCamp
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpv
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpvCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressions
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressionsCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReach
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReachCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMedia
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekSum
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.model.CpmDefault
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.model.PeriodFixBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpaPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetAvgCpcPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetCrr
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetMedia
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetRoi
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddAutobudgetWeekBundle
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddDefaultManualStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddPackageStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgCpa
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgCpm
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithAvgCpv
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithCustomPeriodBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithDayBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithMeaningfulGoals
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithMetrikaCounters
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithPayForConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdAddStrategyWithWeeklyBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpaPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetAvgCpcPerFilter
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetCrr
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetMedia
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetRoi
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateAutobudgetWeekBundle
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateDefaultManualStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdatePackageStrategy
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgCpa
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgCpm
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithAvgCpv
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithBid
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithCustomPeriodBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithDayBudget
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithMeaningfulGoals
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithMetrikaCounters
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithPayForConversion
import ru.yandex.direct.grid.processing.model.strategy.mutation.GdUpdateStrategyWithWeeklyBudget
import ru.yandex.direct.grid.processing.service.validation.presentation.SkipByDefaultMappingPathNodeConverter
import ru.yandex.direct.validation.result.DefaultPathNodeConverterProvider
import ru.yandex.direct.validation.result.PathNodeConverter

object PackageStrategyPathConverters {
    private val UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER: PathNodeConverter =
        SkipByDefaultMappingPathNodeConverter.builder()
            .replace(CommonStrategy.TYPE, GdUpdatePackageStrategy.TYPE)
            .replace(CommonStrategy.ATTRIBUTION_MODEL, GdUpdatePackageStrategy.ATTRIBUTION_MODEL)
            .replace(CommonStrategy.CIDS, GdUpdatePackageStrategy.CIDS)
            .replace(CommonStrategy.IS_PUBLIC, GdUpdatePackageStrategy.IS_PUBLIC)
            .replace(CommonStrategy.NAME, GdUpdatePackageStrategy.NAME)
            .replace(StrategyWithMetrikaCounters.METRIKA_COUNTERS, GdUpdateStrategyWithMetrikaCounters.METRIKA_COUNTERS)
            .replace(StrategyWithAvgBid.AVG_BID, GdUpdateStrategyWithAvgBid.AVG_BID)
            .replace(StrategyWithAvgCpa.AVG_CPA, GdUpdateStrategyWithAvgCpa.AVG_CPA)
            .replace(StrategyWithAvgCpm.AVG_CPM, GdUpdateStrategyWithAvgCpm.AVG_CPM)
            .replace(StrategyWithAvgCpv.AVG_CPV, GdUpdateStrategyWithAvgCpv.AVG_CPV)
            .replace(StrategyWithBid.BID, GdUpdateStrategyWithBid.BID)
            .replace(StrategyWithConversion.GOAL_ID, GdUpdateStrategyWithConversion.GOAL_ID)
            .replace(StrategyWithCustomPeriodBudget.START, GdUpdateStrategyWithCustomPeriodBudget.START)
            .replace(StrategyWithCustomPeriodBudget.FINISH, GdUpdateStrategyWithCustomPeriodBudget.FINISH)
            .replace(
                StrategyWithCustomPeriodBudget.AUTO_PROLONGATION,
                GdUpdateStrategyWithCustomPeriodBudget.AUTO_PROLONGATION
            )
            .replace(StrategyWithCustomPeriodBudget.BUDGET, GdUpdateStrategyWithCustomPeriodBudget.BUDGET)
            .replace(StrategyWithDayBudget.DAY_BUDGET, GdUpdateStrategyWithDayBudget.DAY_BUDGET)
            .replace(StrategyWithDayBudget.DAY_BUDGET_SHOW_MODE, GdUpdateStrategyWithDayBudget.DAY_BUDGET_SHOW_MODE)
            .replace(StrategyWithMeaningfulGoals.MEANINGFUL_GOALS, GdUpdateStrategyWithMeaningfulGoals.MEANINGFUL_GOALS)
            .replace(
                StrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED,
                GdUpdateStrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED
            )
            .replace(StrategyWithWeeklyBudget.SUM, GdUpdateStrategyWithWeeklyBudget.SUM)
            .replace(AutobudgetCrr.CRR, GdUpdateAutobudgetCrr.CRR)
            .replace(AutobudgetAvgCpaPerFilter.FILTER_AVG_CPA, GdUpdateAutobudgetAvgCpaPerFilter.FILTER_AVG_CPA)
            .replace(AutobudgetRoi.ROI_COEF, GdUpdateAutobudgetRoi.ROI_COEF)
            .replace(AutobudgetRoi.RESERVE_RETURN, GdUpdateAutobudgetRoi.RESERVE_RETURN)
            .replace(AutobudgetRoi.PROFITABILITY, GdUpdateAutobudgetRoi.PROFITABILITY)
            .replace(AutobudgetAvgCpcPerFilter.FILTER_AVG_BID, GdUpdateAutobudgetAvgCpcPerFilter.FILTER_AVG_BID)
            .replace(AutobudgetMedia.DATE, GdUpdateAutobudgetMedia.DATE)
            .replace(AutobudgetWeekBundle.LIMIT_CLICKS, GdUpdateAutobudgetWeekBundle.LIMIT_CLICKS)
            .replace(DefaultManualStrategy.ENABLE_CPC_HOLD, GdUpdateDefaultManualStrategy.ENABLE_CPC_HOLD)
            .build()

    private val ADD_PACKAGE_STRATEGIES_PATH_CONVERTER: PathNodeConverter =
        SkipByDefaultMappingPathNodeConverter.builder()
            .replace(CommonStrategy.TYPE, GdAddPackageStrategy.TYPE)
            .replace(CommonStrategy.ATTRIBUTION_MODEL, GdAddPackageStrategy.ATTRIBUTION_MODEL)
            .replace(CommonStrategy.CIDS, GdAddPackageStrategy.CIDS)
            .replace(CommonStrategy.IS_PUBLIC, GdAddPackageStrategy.IS_PUBLIC)
            .replace(CommonStrategy.NAME, GdAddPackageStrategy.NAME)
            .replace(StrategyWithMetrikaCounters.METRIKA_COUNTERS, GdAddStrategyWithMetrikaCounters.METRIKA_COUNTERS)
            .replace(StrategyWithAvgBid.AVG_BID, GdAddStrategyWithAvgBid.AVG_BID)
            .replace(StrategyWithAvgCpa.AVG_CPA, GdAddStrategyWithAvgCpa.AVG_CPA)
            .replace(StrategyWithAvgCpm.AVG_CPM, GdAddStrategyWithAvgCpm.AVG_CPM)
            .replace(StrategyWithAvgCpv.AVG_CPV, GdAddStrategyWithAvgCpv.AVG_CPV)
            .replace(StrategyWithBid.BID, GdAddStrategyWithBid.BID)
            .replace(StrategyWithConversion.GOAL_ID, GdAddStrategyWithConversion.GOAL_ID)
            .replace(StrategyWithCustomPeriodBudget.START, GdAddStrategyWithCustomPeriodBudget.START)
            .replace(StrategyWithCustomPeriodBudget.FINISH, GdAddStrategyWithCustomPeriodBudget.FINISH)
            .replace(
                StrategyWithCustomPeriodBudget.AUTO_PROLONGATION,
                GdAddStrategyWithCustomPeriodBudget.AUTO_PROLONGATION
            )
            .replace(StrategyWithCustomPeriodBudget.BUDGET, GdAddStrategyWithCustomPeriodBudget.BUDGET)
            .replace(StrategyWithDayBudget.DAY_BUDGET, GdAddStrategyWithDayBudget.DAY_BUDGET)
            .replace(StrategyWithDayBudget.DAY_BUDGET_SHOW_MODE, GdAddStrategyWithDayBudget.DAY_BUDGET_SHOW_MODE)
            .replace(StrategyWithMeaningfulGoals.MEANINGFUL_GOALS, GdAddStrategyWithMeaningfulGoals.MEANINGFUL_GOALS)
            .replace(
                StrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED,
                GdAddStrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED
            )
            .replace(StrategyWithWeeklyBudget.SUM, GdAddStrategyWithWeeklyBudget.SUM)
            .replace(AutobudgetCrr.CRR, GdAddAutobudgetCrr.CRR)
            .replace(AutobudgetAvgCpaPerFilter.FILTER_AVG_CPA, GdAddAutobudgetAvgCpaPerFilter.FILTER_AVG_CPA)
            .replace(AutobudgetRoi.ROI_COEF, GdAddAutobudgetRoi.ROI_COEF)
            .replace(AutobudgetRoi.RESERVE_RETURN, GdAddAutobudgetRoi.RESERVE_RETURN)
            .replace(AutobudgetRoi.PROFITABILITY, GdAddAutobudgetRoi.PROFITABILITY)
            .replace(AutobudgetAvgCpcPerFilter.FILTER_AVG_BID, GdAddAutobudgetAvgCpcPerFilter.FILTER_AVG_BID)
            .replace(AutobudgetMedia.DATE, GdAddAutobudgetMedia.DATE)
            .replace(AutobudgetWeekBundle.LIMIT_CLICKS, GdAddAutobudgetWeekBundle.LIMIT_CLICKS)
            .replace(DefaultManualStrategy.ENABLE_CPC_HOLD, GdAddDefaultManualStrategy.ENABLE_CPC_HOLD)
            .build()

    val addPathNodeConverterProvider = DefaultPathNodeConverterProvider.builder()
        .register(AutobudgetCrr::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetWeekSum::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(DefaultManualStrategy::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(CpmDefault::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpvCustomPeriod::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpv::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpaPerCamp::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpaPerFilter::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpa::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpi::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetRoi::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgClick::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpcPerCamp::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpcPerFilter::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxImpressions::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxImpressionsCustomPeriod::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxReach::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxReachCustomPeriod::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMedia::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetWeekBundle::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(PeriodFixBid::class.java, ADD_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .build()

    val pathNodeConverterProvider = DefaultPathNodeConverterProvider.builder()
        .register(AutobudgetCrr::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetWeekSum::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(DefaultManualStrategy::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(CpmDefault::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpvCustomPeriod::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpv::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpaPerCamp::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpaPerFilter::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpa::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpi::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetRoi::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgClick::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpcPerCamp::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetAvgCpcPerFilter::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxImpressions::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxImpressionsCustomPeriod::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxReach::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMaxReachCustomPeriod::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetMedia::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(AutobudgetWeekBundle::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .register(PeriodFixBid::class.java, UPDATE_PACKAGE_STRATEGIES_PATH_CONVERTER)
        .build()
}
