package ru.yandex.direct.grid.processing.service.strategy.query

import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgClick
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpa
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerCamp
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerCamp
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpv
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpvCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressions
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressionsCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReach
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReachCustomPeriod
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMedia
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekSum
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.model.CpmDefault
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.model.PeriodFixBid
import ru.yandex.direct.core.entity.strategy.model.StrategyAttributionModel
import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithLastBidderRestartTime
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toGdMeaningFulGoals
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgClick
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpa
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpaPerCamp
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpaPerFilter
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpcPerCamp
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpcPerFilter
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpi
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpv
import ru.yandex.direct.grid.model.strategy.GdAutobudgetAvgCpvCustomPeriod
import ru.yandex.direct.grid.model.strategy.GdAutobudgetCrr
import ru.yandex.direct.grid.model.strategy.GdAutobudgetMaxImpressions
import ru.yandex.direct.grid.model.strategy.GdAutobudgetMaxImpressionsCustomPeriod
import ru.yandex.direct.grid.model.strategy.GdAutobudgetMaxReach
import ru.yandex.direct.grid.model.strategy.GdAutobudgetMaxReachCustomPeriod
import ru.yandex.direct.grid.model.strategy.GdAutobudgetMedia
import ru.yandex.direct.grid.model.strategy.GdAutobudgetRoi
import ru.yandex.direct.grid.model.strategy.GdAutobudgetWeekBundle
import ru.yandex.direct.grid.model.strategy.GdAutobudgetWeekSum
import ru.yandex.direct.grid.model.strategy.GdCpmDefault
import ru.yandex.direct.grid.model.strategy.GdDefaultManualStrategy
import ru.yandex.direct.grid.model.strategy.GdPackageStrategy
import ru.yandex.direct.grid.model.strategy.GdPeriodFixBid
import ru.yandex.direct.grid.model.strategy.GdStrategyAttributionModel
import ru.yandex.direct.grid.model.strategy.GdStrategyAttributionModelConverter
import ru.yandex.direct.grid.model.strategy.GdStrategyDayBudgetShowMode
import ru.yandex.direct.grid.model.strategy.GdStrategyDayBudgetShowModeConverter
import ru.yandex.direct.grid.model.strategy.GdStrategyName
import ru.yandex.direct.grid.model.strategy.GdStrategyNameConverter
import ru.yandex.direct.grid.model.strategy.GdStrategyWithAvgBid
import ru.yandex.direct.grid.model.strategy.GdStrategyWithAvgCpa
import ru.yandex.direct.grid.model.strategy.GdStrategyWithAvgCpm
import ru.yandex.direct.grid.model.strategy.GdStrategyWithAvgCpv
import ru.yandex.direct.grid.model.strategy.GdStrategyWithBid
import ru.yandex.direct.grid.model.strategy.GdStrategyWithConversion
import ru.yandex.direct.grid.model.strategy.GdStrategyWithCustomPeriodBudget
import ru.yandex.direct.grid.model.strategy.GdStrategyWithDayBudget
import ru.yandex.direct.grid.model.strategy.GdStrategyWithLastBidderRestartTime
import ru.yandex.direct.grid.model.strategy.GdStrategyWithMeaningfulGoals
import ru.yandex.direct.grid.model.strategy.GdStrategyWithMetrikaCounters
import ru.yandex.direct.grid.model.strategy.GdStrategyWithPayForConversion
import ru.yandex.direct.grid.model.strategy.GdStrategyWithWeeklyBudget

/*
* Конвертер внутреннего представления пакетной стратегии во внешнее представление.
* Если нужно использовать какой-то из приватных методов, то вынесите его отсюда и сделайте публичным.
* */
object GdPackageConverter {

    fun convert(strategy: CommonStrategy): GdPackageStrategy? {
        val gdStrategy = when (strategy) {
            is AutobudgetWeekSum ->
                GdAutobudgetWeekSum()
            is DefaultManualStrategy ->
                GdDefaultManualStrategy()
                    .withEnableCpcHold(strategy.enableCpcHold)
            is CpmDefault ->
                GdCpmDefault()
            is AutobudgetAvgCpvCustomPeriod ->
                GdAutobudgetAvgCpvCustomPeriod()
            is AutobudgetAvgCpv ->
                GdAutobudgetAvgCpv()
            is AutobudgetCrr ->
                GdAutobudgetCrr()
                    .withCrr(strategy.crr)
            is AutobudgetAvgCpaPerCamp ->
                GdAutobudgetAvgCpaPerCamp()
            is AutobudgetAvgCpaPerFilter ->
                GdAutobudgetAvgCpaPerFilter()
                    .withFilterAvgCpa(strategy.filterAvgCpa)
            is AutobudgetAvgCpa ->
                GdAutobudgetAvgCpa()
            is AutobudgetAvgCpi ->
                GdAutobudgetAvgCpi()
            is AutobudgetRoi ->
                GdAutobudgetRoi()
                    .withRoiCoef(strategy.roiCoef)
                    .withReserveReturn(strategy.reserveReturn)
                    .withProfitability(strategy.profitability)
            is AutobudgetAvgClick ->
                GdAutobudgetAvgClick()
            is AutobudgetAvgCpcPerCamp ->
                GdAutobudgetAvgCpcPerCamp()
            is AutobudgetAvgCpcPerFilter ->
                GdAutobudgetAvgCpcPerFilter()
                    .withFilterAvgBid(strategy.filterAvgBid)
            is AutobudgetMaxImpressions ->
                GdAutobudgetMaxImpressions()
            is AutobudgetMaxImpressionsCustomPeriod ->
                GdAutobudgetMaxImpressionsCustomPeriod()
            is AutobudgetMaxReach ->
                GdAutobudgetMaxReach()
            is AutobudgetMaxReachCustomPeriod ->
                GdAutobudgetMaxReachCustomPeriod()
            is AutobudgetMedia ->
                GdAutobudgetMedia()
                    .withDate(strategy.date)
            is AutobudgetWeekBundle ->
                GdAutobudgetWeekBundle()
                    .withLimitClicks(strategy.limitClicks)
            is PeriodFixBid -> GdPeriodFixBid()
            //CommonStrategy is not sealed interface
            else -> null
        }
        return gdStrategy?.let { fillCommon(strategy, it) }
    }

    fun toGdStrategyName(type: StrategyName): GdStrategyName =
        GdStrategyNameConverter.fromSource(type)

    fun toGdAttributionModel(attributionModel: StrategyAttributionModel): GdStrategyAttributionModel =
        GdStrategyAttributionModelConverter.fromSource(attributionModel)

    fun toGdDayBudgetShowMode(showMode: StrategyDayBudgetShowMode): GdStrategyDayBudgetShowMode =
        GdStrategyDayBudgetShowModeConverter.fromSource(showMode)

    private fun <T : GdPackageStrategy> fillCommon(strategy: CommonStrategy, instance: T): T {
        instance.id = strategy.id
        instance.type = toGdStrategyName(strategy.type)
        instance.attributionModel = toGdAttributionModel(strategy.attributionModel)
        instance.cids = strategy.cids ?: emptyList()
        instance.clientId = strategy.clientId
        instance.isPublic = strategy.isPublic
        instance.name = strategy.name
        instance.lastChange = strategy.lastChange
        instance.statusArchived = strategy.statusArchived
        instance.walletId = strategy.walletId
        fillMetrikaCounters(strategy, instance)
        fillAvgBid(strategy, instance)
        fillAvgCpa(strategy, instance)
        fillAvgCpm(strategy, instance)
        fillAvgCpv(strategy, instance)
        fillBid(strategy, instance)
        fillStrategyWithConversion(strategy, instance)
        fillCustomPeriodBudget(strategy, instance)
        fillDayBudget(strategy, instance)
        fillMeaningfulGoals(strategy, instance)
        fillLastBidderRestartTime(strategy, instance)
        fillPayForConversion(strategy, instance)
        fillWeeklyBudget(strategy, instance)
        return instance
    }

    private fun <T : GdPackageStrategy> fillMetrikaCounters(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithMetrikaCounters && instance is GdStrategyWithMetrikaCounters) {
            instance.metrikaCounters = commonStrategy.metrikaCounters
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillAvgBid(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithAvgBid && instance is GdStrategyWithAvgBid) {
            instance.avgBid = commonStrategy.avgBid
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillAvgCpa(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithAvgCpa && instance is GdStrategyWithAvgCpa) {
            instance.avgCpa = commonStrategy.avgCpa
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillAvgCpm(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithAvgCpm && instance is GdStrategyWithAvgCpm) {
            instance.avgCpm = commonStrategy.avgCpm
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillAvgCpv(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithAvgCpv && instance is GdStrategyWithAvgCpv) {
            instance.avgCpv = commonStrategy.avgCpv
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillBid(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithBid && instance is GdStrategyWithBid) {
            instance.bid = commonStrategy.bid
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillStrategyWithConversion(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithConversion && instance is GdStrategyWithConversion) {
            instance.goalId = commonStrategy.goalId
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillCustomPeriodBudget(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithCustomPeriodBudget && instance is GdStrategyWithCustomPeriodBudget) {
            instance.start = commonStrategy.start
            instance.finish = commonStrategy.finish
            instance.autoProlongation = commonStrategy.autoProlongation
            instance.budget = commonStrategy.budget
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillDayBudget(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithDayBudget && instance is GdStrategyWithDayBudget) {
            instance.dayBudget = commonStrategy.dayBudget
            instance.dayBudgetShowMode = toGdDayBudgetShowMode(commonStrategy.dayBudgetShowMode)
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillLastBidderRestartTime(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithLastBidderRestartTime && instance is GdStrategyWithLastBidderRestartTime) {
            instance.lastBidderRestartTime = commonStrategy.lastBidderRestartTime
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillMeaningfulGoals(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithMeaningfulGoals && instance is GdStrategyWithMeaningfulGoals) {
            instance.meaningfulGoals = toGdMeaningFulGoals(commonStrategy.meaningfulGoals)
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillPayForConversion(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithPayForConversion && instance is GdStrategyWithPayForConversion) {
            instance.isPayForConversionEnabled = commonStrategy.isPayForConversionEnabled
        }
        return instance
    }

    private fun <T : GdPackageStrategy> fillWeeklyBudget(commonStrategy: CommonStrategy, instance: T): T {
        if (commonStrategy is StrategyWithWeeklyBudget && instance is GdStrategyWithWeeklyBudget) {
            instance.sum = commonStrategy.sum
        }
        return instance
    }
}
