package ru.yandex.direct.grid.processing.service.strategy.query

import ru.yandex.direct.grid.core.util.filters.FilterProcessor
import ru.yandex.direct.grid.core.util.filters.FilterProvider.contains
import ru.yandex.direct.grid.core.util.filters.FilterProvider.equalTo
import ru.yandex.direct.grid.core.util.filters.FilterProvider.greaterOrEqual
import ru.yandex.direct.grid.core.util.filters.FilterProvider.lessOrEqual
import ru.yandex.direct.grid.core.util.filters.FilterProvider.numericContainsAny
import ru.yandex.direct.grid.model.GdEntityStats
import ru.yandex.direct.grid.model.GdEntityStatsFilter
import ru.yandex.direct.grid.model.GdGoalStatsFilter
import ru.yandex.direct.grid.model.strategy.GdPackageStrategy
import ru.yandex.direct.grid.processing.model.strategy.query.GdPackageStrategyFilter
import ru.yandex.direct.grid.processing.util.StatHelper
import ru.yandex.direct.validation.BiPredicates.not

object PackageStrategyFilterProcessor {

    val DEFAULT_PACKAGE_STRATEGY_FILTER_PROCESSOR = getFilterProcessor()

    private fun getFilterProcessor(): FilterProcessor<GdPackageStrategyFilter, GdPackageStrategy> {
        val builder = FilterProcessor.Builder<GdPackageStrategyFilter, GdPackageStrategy>()

        builder
            .withFilter(GdPackageStrategyFilter::getStrategyIdIn, contains(GdPackageStrategy::getId))
            .withFilter(GdPackageStrategyFilter::getIsPublic, equalTo(GdPackageStrategy::getIsPublic))
            .withFilter(GdPackageStrategyFilter::getStrategyIdNotIn, not(contains(GdPackageStrategy::getId)))
            .withFilter(GdPackageStrategyFilter::getStrategyIdContainsAny, numericContainsAny(GdPackageStrategy::getId))
            .withFilter(GdPackageStrategyFilter::getStrategyTypeIn, contains(GdPackageStrategy::getType))
            .withFilter(GdPackageStrategyFilter::getStrategyTypeNotIn, not(contains(GdPackageStrategy::getType)))
            .withFilter(GdPackageStrategyFilter::getIsArchived, equalTo(GdPackageStrategy::getStatusArchived))

        return builder.build()
    }

    val ENTITY_STATS_FILTER_PROCESSOR =
        getEntityStatsFilterProcessorBuilder().build(GdPackageStrategy::getStats)

    fun applyGoalsStatFilters(
        goalStatFilters: List<GdGoalStatsFilter>?,
        gdPackageStrategy: GdPackageStrategy
    ): Boolean = StatHelper.applyGoalsStatFilters(goalStatFilters, gdPackageStrategy.goalStats)

    private fun getEntityStatsFilterProcessorBuilder(): FilterProcessor.Builder<GdEntityStatsFilter, GdEntityStats> {
        val builder = FilterProcessor.Builder<GdEntityStatsFilter, GdEntityStats>()

        builder
            .withFilter(GdEntityStatsFilter::getMinCost, greaterOrEqual(GdEntityStats::getCost))
            .withFilter(GdEntityStatsFilter::getMaxCost, lessOrEqual(GdEntityStats::getCost))
            .withFilter(GdEntityStatsFilter::getMinCostWithTax, greaterOrEqual(GdEntityStats::getCostWithTax))
            .withFilter(GdEntityStatsFilter::getMaxCostWithTax, lessOrEqual(GdEntityStats::getCostWithTax))
            .withFilter(GdEntityStatsFilter::getMinShows, greaterOrEqual(GdEntityStats::getShows))
            .withFilter(GdEntityStatsFilter::getMaxShows, lessOrEqual(GdEntityStats::getShows))
            .withFilter(GdEntityStatsFilter::getMinClicks, greaterOrEqual(GdEntityStats::getClicks))
            .withFilter(GdEntityStatsFilter::getMaxClicks, lessOrEqual(GdEntityStats::getClicks))
            .withFilter(GdEntityStatsFilter::getMinCtr, greaterOrEqual(GdEntityStats::getCtr))
            .withFilter(GdEntityStatsFilter::getMaxCtr, lessOrEqual(GdEntityStats::getCtr))
            .withFilter(GdEntityStatsFilter::getMinAvgClickCost, greaterOrEqual(GdEntityStats::getAvgClickCost))
            .withFilter(GdEntityStatsFilter::getMaxAvgClickCost, lessOrEqual(GdEntityStats::getAvgClickCost))
            .withFilter(GdEntityStatsFilter::getMinAvgShowPosition, greaterOrEqual(GdEntityStats::getAvgShowPosition))
            .withFilter(GdEntityStatsFilter::getMaxAvgShowPosition, lessOrEqual(GdEntityStats::getAvgShowPosition))
            .withFilter(GdEntityStatsFilter::getMinAvgClickPosition, greaterOrEqual(GdEntityStats::getAvgClickPosition))
            .withFilter(GdEntityStatsFilter::getMaxAvgClickPosition, lessOrEqual(GdEntityStats::getAvgClickPosition))
            .withFilter(GdEntityStatsFilter::getMinBounceRate, greaterOrEqual(GdEntityStats::getBounceRate))
            .withFilter(GdEntityStatsFilter::getMaxBounceRate, lessOrEqual(GdEntityStats::getBounceRate))
            .withFilter(GdEntityStatsFilter::getMinConversionRate, greaterOrEqual(GdEntityStats::getConversionRate))
            .withFilter(GdEntityStatsFilter::getMaxConversionRate, lessOrEqual(GdEntityStats::getConversionRate))
            .withFilter(GdEntityStatsFilter::getMinAvgGoalCost, greaterOrEqual(GdEntityStats::getAvgGoalCost))
            .withFilter(GdEntityStatsFilter::getMaxAvgGoalCost, lessOrEqual(GdEntityStats::getAvgGoalCost))
            .withFilter(GdEntityStatsFilter::getMinGoals, greaterOrEqual(GdEntityStats::getGoals))
            .withFilter(GdEntityStatsFilter::getMaxGoals, lessOrEqual(GdEntityStats::getGoals))
            .withFilter(GdEntityStatsFilter::getMinAvgDepth, greaterOrEqual(GdEntityStats::getAvgDepth))
            .withFilter(GdEntityStatsFilter::getMaxAvgDepth, lessOrEqual(GdEntityStats::getAvgDepth))
            .withFilter(GdEntityStatsFilter::getMinProfitability, greaterOrEqual(GdEntityStats::getProfitability))
            .withFilter(GdEntityStatsFilter::getMaxProfitability, lessOrEqual(GdEntityStats::getProfitability))
            .withFilter(GdEntityStatsFilter::getMinCrr, greaterOrEqual(GdEntityStats::getCrr))
            .withFilter(GdEntityStatsFilter::getMaxCrr, lessOrEqual(GdEntityStats::getCrr))
            .withFilter(GdEntityStatsFilter::getMinRevenue, greaterOrEqual(GdEntityStats::getRevenue))
            .withFilter(GdEntityStatsFilter::getMaxRevenue, lessOrEqual(GdEntityStats::getRevenue))
            .withFilter(GdEntityStatsFilter::getMinCpmPrice, greaterOrEqual(GdEntityStats::getCpmPrice))
            .withFilter(GdEntityStatsFilter::getMaxCpmPrice, lessOrEqual(GdEntityStats::getCpmPrice))

        return builder
    }
}
