package ru.yandex.direct.grid.processing.service.strategy.utils

import ru.yandex.direct.grid.core.entity.model.campaign.GdiCampaignStats
import ru.yandex.direct.grid.model.strategy.GdPackageStrategy
import ru.yandex.direct.grid.model.strategy.GdStrategyName
import ru.yandex.direct.grid.model.strategy.GdStrategyWithConversion
import ru.yandex.direct.grid.processing.service.campaign.ConversionStrategyLearningData
import java.time.LocalDate

class ConversionPackageStrategyLearningData(
    val strategy: GdPackageStrategy,
    val lastRestartBidderTime: LocalDate,
    stats: GdiCampaignStats,
    lastDayStats: GdiCampaignStats
) : ConversionStrategyLearningData(
    if (strategy is GdStrategyWithConversion) strategy.goalId else null,
    stats,
    lastDayStats) {

    override fun isRevenueModelStrategy(): Boolean =
        strategy.type == GdStrategyName.AUTOBUDGET_CRR

    override fun restartOrStartDate(): LocalDate =
        lastRestartBidderTime

    override fun startDate(): LocalDate =
        lastRestartBidderTime

}
