package ru.yandex.direct.grid.processing.service.targets;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.targets.GdTarget;
import ru.yandex.direct.grid.processing.model.targets.GdTargetFilter;
import ru.yandex.direct.grid.processing.model.targets.GdTargetsContainer;

import static java.util.Arrays.asList;
import static ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType.TEXT;
import static ru.yandex.direct.grid.processing.service.targets.Target.family;
import static ru.yandex.direct.grid.processing.service.targets.Target.geo;
import static ru.yandex.direct.grid.processing.service.targets.Target.interests;
import static ru.yandex.direct.grid.processing.service.targets.Target.metrika;
import static ru.yandex.direct.grid.processing.service.targets.Target.social_demo;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Service
@ParametersAreNonnullByDefault
public class TargetService {

    public List<GdTarget> getTargets(GdTargetsContainer input) {
        GdAdGroupType gdAdGroupType = ifNotNull(input.getFilter(), GdTargetFilter::getGroupType);

        List<Target> targets;
        if (gdAdGroupType == null) {
            targets = asList(Target.values());
        } else if (gdAdGroupType == TEXT) {
            targets = asList(geo, social_demo, family, interests, metrika);
        } else {
            return Collections.emptyList();
        }

        return targets.stream()
                .map(this::convert)
                .collect(Collectors.toList());
    }

    private GdTarget convert(Target t) {
        return new GdTarget()
                .withId((long) t.ordinal())
                .withName(t.name());
    }
}
