package ru.yandex.direct.grid.processing.service.targets;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.model.targets.GdTarget;
import ru.yandex.direct.grid.processing.model.targets.GdTargetContext;
import ru.yandex.direct.grid.processing.model.targets.GdTargetsContainer;

/**
 * Сервис, возвращающий данные о таргетах
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class TargetsGraphQlService {
    private static final String TARGETS_RESOLVER_NAME = "targets";

    private final TargetService targetService;

    @Autowired
    public TargetsGraphQlService(
            TargetService targetService) {
        this.targetService = targetService;
    }

    /**
     * GraphQL подзапрос. Получает справочник таргетов
     *
     * @param input   параметры фильтра и вывода
     */
    @GraphQLNonNull
    @GraphQLQuery(name = TARGETS_RESOLVER_NAME)
    public GdTargetContext getTargets(@GraphQLNonNull @GraphQLArgument(name = "input") GdTargetsContainer input) {

        List<GdTarget> gdTargets = targetService.getTargets(input);
        return new GdTargetContext()
                .withRowset(gdTargets)
                .withTotalCount(gdTargets.size());
    }
}
