package ru.yandex.direct.grid.processing.service.targettag;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.targettag.repository.TargetTagRepository;
import ru.yandex.direct.core.entity.targettags.model.TargetTag;
import ru.yandex.direct.grid.processing.model.targettag.GdTargetTag;
import ru.yandex.direct.grid.processing.service.pricepackage.converter.PricePackageDataConverter;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class TargetTagDataService {
    private static final int MAX_TAGS_FOR_SUGGEST = 20;

    private final TargetTagRepository targetTagRepository;

    @Autowired
    public TargetTagDataService(TargetTagRepository targetTagRepository) {
        this.targetTagRepository = targetTagRepository;
    }

    public List<GdTargetTag> findTargetTags(String targetTagNamePrefix) {
        List<TargetTag> targetTags = targetTagRepository.findTargetTagsByNamePrefix(targetTagNamePrefix,
                MAX_TAGS_FOR_SUGGEST);
        return mapList(targetTags, PricePackageDataConverter::toGdTargetTag);
    }
}
