package ru.yandex.direct.grid.processing.service.targettag;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.targettag.GdFindTargetTagFilter;
import ru.yandex.direct.grid.processing.model.targettag.GdTargetTag;
import ru.yandex.direct.rbac.RbacRole;

import static ru.yandex.direct.core.entity.user.utils.UserUtil.hasOneOfRoles;

/**
 * Сервис, возвращающий данные о таргет тегах
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class TargetTagGraphQlService {
    private static final String TARGET_TAGS_SUGGEST_RESOLVER_NAME = "findTargetTags";

    private final TargetTagDataService targetTagDataService;

    @Autowired
    public TargetTagGraphQlService(TargetTagDataService productDataService) {
        this.targetTagDataService = productDataService;
    }

    /**
     * Отдаём список таргет тегов под условие поиска для саджеста.
     *
     * @param input параметры фильтра
     */
    @GraphQLNonNull
    @GraphQLQuery(name = TARGET_TAGS_SUGGEST_RESOLVER_NAME)
    public List<GdTargetTag> findTargetTags(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdFindTargetTagFilter input)
    {
        if (!hasOneOfRoles(context.getOperator(), RbacRole.SUPER, RbacRole.SUPERREADER,
                RbacRole.MANAGER, RbacRole.SUPPORT)) {
            return Collections.emptyList();
        }

        return targetTagDataService.findTargetTags(input.getName());
    }
}
