package ru.yandex.direct.grid.processing.service.tools;

import java.math.BigDecimal;
import java.math.RoundingMode;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.geosearch.model.GeoObject;
import ru.yandex.direct.grid.processing.model.GdCoordinates;
import ru.yandex.direct.grid.processing.model.GdGeoToolsResponse;

@ParametersAreNonnullByDefault
class GeoToolsConverter {
    static final int COORDINATES_PRECISION = 6;

    static String coordinatesToString(GdCoordinates coordinates) {
        return String.join(",", toRequestCoordinate(coordinates.getX()), toRequestCoordinate(coordinates.getY()));
    }

    static String toRequestCoordinate(BigDecimal value) {
        return value.setScale(COORDINATES_PRECISION, RoundingMode.HALF_UP).toPlainString();
    }

    static GdGeoToolsResponse toGdGeoToolsResponse(GeoObject geoObject) {
        return new GdGeoToolsResponse()
                .withGeoId(geoObject.getGeoId())
                .withCountry(geoObject.getCountry())
                .withAdministrativeArea(geoObject.getAdministrativeArea())
                .withCity(geoObject.getCity())
                .withStreet(geoObject.getStreet())
                .withHouse(geoObject.getHouse());
    }
}
