package ru.yandex.direct.grid.processing.service.tools;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.model.GdCoordinates;
import ru.yandex.direct.grid.processing.model.GdGeoToolsAddress;
import ru.yandex.direct.grid.processing.model.GdGeoToolsResponse;
import ru.yandex.direct.grid.processing.model.GdPhoneCodes;
import ru.yandex.direct.grid.processing.model.GdRegion;

/**
 * Сервис, поставляющий данные от Geocoder'а и Geobase
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class GeoToolsGraphQlService {
    private final GeoToolsService geoToolsService;

    @Autowired
    public GeoToolsGraphQlService(GeoToolsService geoToolsService) {
        this.geoToolsService = geoToolsService;
    }

    /**
     * GraphQL запрос на получение данным ближайшей станции метро по координатам
     */
    @GraphQLQuery(name = "getMetroByCoordinates")
    public GdGeoToolsResponse getMetroByCoordinates(
            @GraphQLNonNull @GraphQLArgument(name = "coordinates") GdCoordinates coordinates) {
        return geoToolsService.getMetroByCoordinates(coordinates);
    }

    /**
     * GraphQL запрос на получение объекта по адресу
     */
    @GraphQLQuery(name = "getGeoByAddress")
    public GdGeoToolsResponse getByAddress(
            @GraphQLNonNull @GraphQLArgument(name = "address") GdGeoToolsAddress address) {
        return geoToolsService.getByAddress(address);
    }

    /**
     * GraphQL запрос на получение объекта по координатам
     */
    @GraphQLQuery(name = "getGeoByCoordinates")
    public GdGeoToolsResponse getGeoByCoordinates(
            @GraphQLNonNull @GraphQLArgument(name = "coordinates") GdCoordinates coordinates) {
        return geoToolsService.getGeoByCoordinates(coordinates);
    }


    /**
     * GraphQL запрос на получение объекта по координатам
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "getPhoneCodeByRegionId")
    public GdPhoneCodes getPhoneCodeByRegionId(
            @GraphQLNonNull @GraphQLArgument(name = "region") GdRegion region) {
        return geoToolsService.getPhoneCodeByRegionId(region);
    }

}
