package ru.yandex.direct.grid.processing.service.touchsocdem.service;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.grid.core.entity.touchsocdem.service.GridTouchSocdemService;
import ru.yandex.direct.grid.core.entity.touchsocdem.service.converter.GridTouchSocdemConverter;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.group.GdTextAdGroup;
import ru.yandex.direct.grid.processing.model.touchsocdem.GdTouchSocdem;
import ru.yandex.direct.grid.processing.model.touchsocdem.GdiTouchSocdem;
import ru.yandex.direct.grid.processing.service.touchsocdem.service.converter.TouchSocdemConverter;

import static com.google.common.base.Preconditions.checkNotNull;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class TouchSocdemGraphQlService {
    public static final String TOUCH_SOCDEM_RESOLVER_NAME = "touchSocdem";

    private final GridTouchSocdemService gridTouchSocdemService;

    @Autowired
    public TouchSocdemGraphQlService(GridTouchSocdemService touchSocdemDataService) {
        this.gridTouchSocdemService = touchSocdemDataService;
    }

    /**
     * Соцдем псевдотаргетинг для тачёвой версии Директа.
     * Вычисляется из соцдем корректировки в ТГО группе.
     *
     * @see GridTouchSocdemConverter#socdemBidModifierToTouchSocdem(BidModifierDemographics)
     */
    @GraphQLQuery(name = TOUCH_SOCDEM_RESOLVER_NAME)
    public GdTouchSocdem getTextAdGroupTouchSocdem(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLContext GdTextAdGroup gdTextAdGroup
    ) {
        checkNotNull(context.getQueriedClient(), "must be called in client context");
        GdiTouchSocdem gdi = gridTouchSocdemService.getTouchSocdem(
                context.getQueriedClient().getShard(),
                gdTextAdGroup.getId()
        );
        return gdi == null ? null : TouchSocdemConverter.toOuterTouchSocdem(gdi);
    }
}
