package ru.yandex.direct.grid.processing.service.touchsocdem.service.converter;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.processing.model.touchsocdem.GdTouchSocdem;
import ru.yandex.direct.grid.processing.model.touchsocdem.GdTouchSocdemAgePoint;
import ru.yandex.direct.grid.processing.model.touchsocdem.GdTouchSocdemGender;
import ru.yandex.direct.grid.processing.model.touchsocdem.GdTouchSocdemInput;
import ru.yandex.direct.grid.processing.model.touchsocdem.GdiTouchSocdem;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Конвертеры из GdTouchSocdem в GdiTouchSocdem и обратно
 */
@ParametersAreNonnullByDefault
public class TouchSocdemConverter {
    public static GdTouchSocdem toOuterTouchSocdem(GdiTouchSocdem gdi) {
        return new GdTouchSocdem()
                .withIncompleteBidModifier(gdi.getIncompleteBidModifier())
                .withAgeLower(GdTouchSocdemAgePoint.fromSource(gdi.getAgeLower()))
                .withAgeUpper(GdTouchSocdemAgePoint.fromSource(gdi.getAgeUpper()))
                .withGenders(mapList(gdi.getGenders(), GdTouchSocdemGender::fromSource));
    }

    @Nullable
    public static GdiTouchSocdem toInnerTouchSocdem(@Nullable GdTouchSocdemInput gd) {
        if (gd == null) {
            return null;
        }
        return new GdiTouchSocdem()
                .withIncompleteBidModifier(false)
                .withAgeLower(GdTouchSocdemAgePoint.toSource(gd.getAgeLower()))
                .withAgeUpper(GdTouchSocdemAgePoint.toSource(gd.getAgeUpper()))
                .withGenders(mapList(gd.getGenders(), GdTouchSocdemGender::toSource));
    }
}
