package ru.yandex.direct.grid.processing.service.trackingphone;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.calltrackingsettings.service.CalltrackingSettingsService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.campaign.GdCampaignTruncated;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.model.trackingphone.GdCalltrackingOnSiteCampaigns;
import ru.yandex.direct.grid.processing.model.trackingphone.GdCalltrackingOnSiteCampaignsPayload;
import ru.yandex.direct.grid.processing.service.campaign.CampaignInfoService;

import static java.util.Collections.emptySet;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class CalltrackingOnSiteCampaignDataService {

    private final CampaignInfoService campaignInfoService;
    private final CalltrackingSettingsService calltrackingSettingsService;

    public CalltrackingOnSiteCampaignDataService(
            CampaignInfoService campaignInfoService,
            CalltrackingSettingsService calltrackingSettingsService
    ) {
        this.campaignInfoService = campaignInfoService;
        this.calltrackingSettingsService = calltrackingSettingsService;
    }

    GdCalltrackingOnSiteCampaignsPayload calltrackingOnSiteCampaigns(
            ClientId clientId,
            GdCalltrackingOnSiteCampaigns input
    ) {
        Set<Long> campaignIds = calltrackingSettingsService.getCampaignIds(clientId, input.getUrl());
        if (campaignIds.isEmpty()) {
            return new GdCalltrackingOnSiteCampaignsPayload()
                    .withCampaigns(emptySet());
        }
        Map<Long, GdCampaignTruncated> campaignMap = campaignInfoService.getTruncatedCampaigns(clientId, campaignIds);
        return new GdCalltrackingOnSiteCampaignsPayload()
                .withCampaigns(new HashSet<>(campaignMap.values()));
    }
}
