package ru.yandex.direct.grid.processing.service.trackingphone;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.processing.model.trackingphone.GdCalltrackingOnSite;
import ru.yandex.direct.grid.processing.model.trackingphone.GdCalltrackingOnSiteInputItem;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Service
@ParametersAreNonnullByDefault
public class CalltrackingOnSiteValidationService {
    private final GridValidationService gridValidationService;

    public CalltrackingOnSiteValidationService(GridValidationService gridValidationService) {
        this.gridValidationService = gridValidationService;
    }

    public void validateGetCalltrackingOnGetByUrl(GdCalltrackingOnSite input) {
        gridValidationService.applyValidator(this::validateCalltrackingOnGetByUrl, input, false);
    }

    public void validateGetCalltrackingOnGetByUrl(String url) {
        gridValidationService.applyValidator(this::validateCalltrackingOnSiteInputGetByUrl, url, false);
    }

    public void validateGetCalltrackingOnSiteGetById(GdCalltrackingOnSite input) {
        gridValidationService.applyValidator(this::validateCalltrackingOnSiteGetById, input, false);
    }

    private ValidationResult<GdCalltrackingOnSiteInputItem, Defect> validateCalltrackingOnSiteInputItemGetByUrl(
            GdCalltrackingOnSiteInputItem item) {
        ModelItemValidationBuilder<GdCalltrackingOnSiteInputItem> vb = ModelItemValidationBuilder.of(item);

        vb.item(GdCalltrackingOnSiteInputItem.URL)
                .check(notNull())
                .check(StringConstraints.validHref());

        vb.item(GdCalltrackingOnSiteInputItem.COUNTER_ID)
                .check(notNull());

        return vb.getResult();
    }

    private ValidationResult<GdCalltrackingOnSiteInputItem, Defect> validateCalltrackingOnSiteInputItemGetById(
            GdCalltrackingOnSiteInputItem item) {
        ModelItemValidationBuilder<GdCalltrackingOnSiteInputItem> vb = ModelItemValidationBuilder.of(item);
        vb.item(GdCalltrackingOnSiteInputItem.CALLTRACKING_SETTINGS_ID)
                .check(notNull());

        return vb.getResult();
    }

    private ValidationResult<GdCalltrackingOnSite, Defect> validateCalltrackingOnGetByUrl(
            GdCalltrackingOnSite req) {
        ModelItemValidationBuilder<GdCalltrackingOnSite> vb = ModelItemValidationBuilder.of(req);

        vb.list(GdCalltrackingOnSite.ITEMS)
                .checkEach(notNull())
                .checkEachBy(this::validateCalltrackingOnSiteInputItemGetByUrl, When.isValid());
        return vb.getResult();
    }

    private ValidationResult<GdCalltrackingOnSite, Defect> validateCalltrackingOnSiteGetById(GdCalltrackingOnSite req) {
        ModelItemValidationBuilder<GdCalltrackingOnSite> vb = ModelItemValidationBuilder.of(req);

        vb.list(GdCalltrackingOnSite.ITEMS)
                .checkEach(notNull())
                .checkEachBy(this::validateCalltrackingOnSiteInputItemGetById, When.isValid());

        return vb.getResult();
    }

    private ValidationResult<String, Defect> validateCalltrackingOnSiteInputGetByUrl(String url) {
        ItemValidationBuilder<String, Defect> vb = ItemValidationBuilder.of(url);
        vb.item(url, "url")
                .check(notNull())
                .check(StringConstraints.validHref());
        return vb.getResult();
    }
}
