package ru.yandex.direct.grid.processing.service.turbolanding;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.turbolanding.GdFindTurboLandings;
import ru.yandex.direct.grid.processing.model.turbolanding.GdFindTurboLandingsResult;

import static ru.yandex.direct.grid.processing.util.TextConstants.INPUT;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class TurboLandingGraphQlService {

    private final TurboLandingDataService turboLandingDataService;

    @Autowired
    public TurboLandingGraphQlService(TurboLandingDataService turboLandingDataService) {
        this.turboLandingDataService = turboLandingDataService;
    }

    /**
     * GraphQL ручка. По переданному списку url находит турболендинги, которым они принадлежат.
     * Если для url турболендинг не найден - такой url будет отсутствовать в ответе.
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "findTurboLandings")
    public GdFindTurboLandingsResult getAutopaySettings(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT) GdFindTurboLandings input
    ) {
        return turboLandingDataService.findTurboLandings(context.getSubjectUser().getClientId(), input);
    }
}
