package ru.yandex.direct.grid.processing.service.user.validation;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.processing.model.user.mutation.GdBlockUser;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.validation.constraints.Constraints.validLogin;
import static ru.yandex.direct.grid.processing.service.validation.GridValidationService.checkMutuallyExclusiveFields;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Service
@ParametersAreNonnullByDefault
public class UserMutationValidationService {

    private final GridValidationService gridValidationService;

    @Autowired
    public UserMutationValidationService(GridValidationService gridValidationService) {
        this.gridValidationService = gridValidationService;
    }

    private static final Validator<GdBlockUser, Defect> BLOCK_USER_REQUEST_VALIDATOR = req -> {
        ModelItemValidationBuilder<GdBlockUser> vb = ModelItemValidationBuilder.of(req);
        vb.check(checkMutuallyExclusiveFields(List.of(GdBlockUser.USER_IDS, GdBlockUser.USER_LOGINS)));

        vb.list(GdBlockUser.USER_IDS)
                .check(notEmptyCollection())
                .checkEach(validId(), When.isValid());

        vb.list(GdBlockUser.USER_LOGINS)
                .check(notEmptyCollection())
                .checkEach(validLogin(), When.isValid());

        return vb.getResult();
    };

    public void validateBlockUserRequest(GdBlockUser blockUser) {
        gridValidationService.applyValidator(BLOCK_USER_REQUEST_VALIDATOR, blockUser, false);
    }

}
