package ru.yandex.direct.grid.processing.service.userphone.service;

import java.util.Optional;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.spring.TestingComponent;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.env.Environment;
import ru.yandex.direct.grid.processing.model.userphone.GdConfirmAndBindPhoneCommitPayload;
import ru.yandex.direct.grid.processing.model.userphone.GdConfirmAndBindPhoneSubmitPayload;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxPhone;

/**
 * Класс для реализации механизма подтверждения телефона без СМС для тестовых сред.
 * Механизм нужен для упрощения ручного тестирования и возможности работы автотестов на Welcome page.
 */
@Service
public class TestUserPhoneService {

    private final UserService userService;

    /**
     * Использован этот телефон, потому его легко запомнить.
     */
    private static final String TEST_PHONE = "+78005553535";
    private static final String TEST_TRACK_ID = "test_track_id";

    @Autowired
    public TestUserPhoneService(UserService userService) {
        this.userService = userService;
    }

    /**
     * @return true, если нужно использовать механизм подтверждения телефона без СМС для метода submit, иначе false
     */
    public boolean isTestCallForSubmit(String phone) {
        return !Environment.getCached().isProductionOrPrestable() && TEST_PHONE.equals(phone);
    }

    @TestingComponent
    public GdConfirmAndBindPhoneSubmitPayload confirmAndBindPhoneSubmit() {
        return new GdConfirmAndBindPhoneSubmitPayload()
                .withTrackId(TEST_TRACK_ID);
    }

    /**
     * @return true, если нужно использовать механизм подтверждения телефона без СМС для метода commit, иначе false
     */
    public boolean isTestCallForCommit(String trackId) {
        return !Environment.getCached().isProductionOrPrestable() && TEST_TRACK_ID.equals(trackId);
    }

    @TestingComponent
    public GdConfirmAndBindPhoneCommitPayload confirmAndBindPhoneCommit(Long operatorUid) {
        Optional<BlackboxPhone> securePhone = StreamEx.of(userService.getAllBlackboxPhones(operatorUid))
                .findAny(blackboxPhone -> blackboxPhone.getIsConfirmedNumber().getOrElse(false));
        Long confirmedPhoneId = securePhone.map(BlackboxPhone::getPhoneId).orElse(null);

        return new GdConfirmAndBindPhoneCommitPayload()
                .withPhoneId(confirmedPhoneId);
    }
}
