package ru.yandex.direct.grid.processing.service.userphone.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.core.entity.user.service.validation.UserValidationService;
import ru.yandex.direct.grid.processing.model.userphone.GdUpdateUserVerifiedPhonePayload;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Service
public class UserPhoneService {

    private final UserService userService;
    private final UserValidationService userValidationService;
    private final GridValidationService gridValidationService;

    @Autowired
    public UserPhoneService(UserService userService,
                            UserValidationService userValidationService,
                            GridValidationService gridValidationService) {
        this.userService = userService;
        this.userValidationService = userValidationService;
        this.gridValidationService = gridValidationService;
    }

    public GdUpdateUserVerifiedPhonePayload updateUserVerifiedPhone(User subjectUser, Long verifiedPhoneId) {
        ModelChanges<User> changes = convertToChanges(subjectUser, verifiedPhoneId);
        AppliedChanges<User> userAppliedChanges = changes.applyTo(subjectUser);

        ValidationResult<User, Defect> vr = userValidationService.validate(userAppliedChanges);
        gridValidationService.throwGridValidationExceptionIfHasErrors(vr);

        userService.update(userAppliedChanges);

        return new GdUpdateUserVerifiedPhonePayload()
                .withSuccess(true);
    }

    private ModelChanges<User> convertToChanges(User user, Long verifiedPhoneId) {
        ModelChanges<User> changes = new ModelChanges<>(user.getUid(), User.class);
        changes.processNotNull(verifiedPhoneId, User.VERIFIED_PHONE_ID);
        return changes;
    }
}
