package ru.yandex.direct.grid.processing.service.userphone.validation;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.CodeDefects.CONFIRMATIONS_LIMIT_EXCEEDED;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.CodeDefects.INVALID_CODE;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.GeneralDefects.INTERNAL_PASSPORT_ERROR;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.GeneralDefects.TOO_MANY_REQUESTS;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.GeneralDefects.UNEXPECTED_ERROR;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.PhoneDefects.EMPTY_PHONE;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.PhoneDefects.INVALID_PHONE;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.PhoneDefects.SMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects.PhoneIdDefects.ALREADY_BIND_AND_SECURE;

public class UserPhoneDefects {

    public enum PhoneDefects implements DefectId<Void> {
        EMPTY_PHONE,
        INVALID_PHONE,
        SMS_LIMIT_EXCEEDED
    }

    public enum PhoneIdDefects implements DefectId<Long> {
        ALREADY_BIND_AND_SECURE
    }

    public enum CodeDefects implements DefectId<Void> {
        INVALID_CODE,
        CONFIRMATIONS_LIMIT_EXCEEDED
    }

    public enum GeneralDefects implements DefectId<Void> {
        UNEXPECTED_ERROR,
        INTERNAL_PASSPORT_ERROR,
        TOO_MANY_REQUESTS
    }

    public static Defect<Void> emptyPhone() {
        return new Defect<>(EMPTY_PHONE);
    }

    public static Defect<Void> invalidPhone() {
        return new Defect<>(INVALID_PHONE);
    }

    public static Defect<Void> smsLimitExceeded() {
        return new Defect<>(SMS_LIMIT_EXCEEDED);
    }

    public static Defect<Void> invalidCode() {
        return new Defect<>(INVALID_CODE);
    }

    public static Defect<Void> unexpectedError() {
        return new Defect<>(UNEXPECTED_ERROR);
    }

    public static Defect<Void> internalPassportError() {
        return new Defect<>(INTERNAL_PASSPORT_ERROR);
    }

    public static Defect<Long> alreadyBindAndSecure(Long phoneId) {
        return new Defect<>(ALREADY_BIND_AND_SECURE, phoneId);
    }

    public static Defect<Void> confirmationsLimitExceeded() {
        return new Defect<>(CONFIRMATIONS_LIMIT_EXCEEDED);
    }

    public static Defect<Void> tooManyRequests() {
        return new Defect<>(TOO_MANY_REQUESTS);
    }
}
