package ru.yandex.direct.grid.processing.service.validation;

import java.util.Set;

import ru.yandex.direct.grid.processing.model.client.GdClientMeasurerSystem;
import ru.yandex.direct.validation.result.Defect;

public class GridDefectDefinitions {
    private GridDefectDefinitions() {
    }

    /**
     * Дефект, отдаваемый при наличии в объекте нескольких заданных взаимоисключающих полей
     */
    public static Defect<Void> mutuallyExclusive() {
        return new Defect<>(GridDefectIds.MUST_BE_MUTUALLY_EXCLUSIVE);
    }

    /**
     * Дефект, отдаваемый при наличии в объекте нескольких полей, которые должны быть или одновременно null, или
     * одновременно не null, но не выполняют этого условия
     */
    static Defect<Void> sameNullState() {
        return new Defect<>(GridDefectIds.MUST_BE_SAME_NULL_STATE);
    }

    /**
     * Дефект, отдаваемый при отсутствии в объекте полей, которые должны быть не null
     */
    public static Defect<Void> mustContainNonNullProps() {
        return new Defect<>(GridDefectIds.MUST_CONTAIN_NON_NULL_PROPS);
    }

    /**
     * Дефект, отдаваемый, когда начало периода позже его конца
     */
    public static Defect<Void> datesFromNotAfterTo() {
        return new Defect<>(GridDefectIds.DATES_FROM_NOT_AFTER_TO);
    }

    /**
     * Дефект, отдаваемый, когда невалидный формат месяца
     */
    public static Defect<Void> invalidMonthFormat() {
        return new Defect<>(GridDefectIds.INVALID_MONTH_FORMAT);
    }

    /**
     * Дефект, отдаваемый при наличии неверных символов в поиске и замене href в баннерах
     */
    public static Defect<Void> invalidFindAndReplaceBannersHrefParamsText() {
        return new Defect<>(GridDefectIds.INVALID_FIND_AND_REPLACE_BANNERS_HREF_PARAMS_TEXT);
    }

    /**
     * Дефект возвращается в случае если в запросе на редактирование есть группы с неподдерживаемым типом
     */
    public static Defect<Void> unsupportedAdGroupType() {
        return new Defect<>(GridDefectIds.UNSUPPORTED_GROUP_TYPE);
    }

    /**
     * Дефект возвращается в случае, если в Union число элементов не равно 1
     */
    public static Defect<Void> invalidUnion() {
        return new Defect<>(GridDefectIds.INVALID_UNION);
    }

    /**
     * Дефект возвращается для невалидных клиентских настроек измерителя
     *
     * @param clientMeasurerSystem тип измерителя
     */
    public static Defect invalidClientMeasurer(GdClientMeasurerSystem clientMeasurerSystem) {
        return new Defect<>(GridDefectIds.Str.INVALID_CLIENT_MEASURER, clientMeasurerSystem.name());
    }

    /**
     * Дефект возвращается для целей по которым в запросе есть сортировка, но в статистике эти цели не указаны
     */
    public static Defect invalidGoalIdsFromOrderBy(Set<Long> goalIds) {
        return new Defect<>(GridDefectIds.Ids.GOAL_IDS_FROM_ORDER_BY_NOT_FOUND_IN_STAT_REQUIREMENTS, goalIds);
    }

}
