package ru.yandex.direct.grid.processing.service.validation.presentation;

import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.UntypedAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.core.entity.feedfilter.model.FeedFilter;
import ru.yandex.direct.core.entity.feedfilter.model.FeedFilterCondition;
import ru.yandex.direct.grid.processing.model.banner.GdAdPrice;
import ru.yandex.direct.grid.processing.model.feedfilter.GdFeedFilter;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupMinusKeywordsItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateContentPromotionAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMobileContentAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdatePerformanceAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateTextAdGroupItem;
import ru.yandex.direct.grid.processing.model.smartfilter.GdSmartFilterCondition;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.PathNodeConverter;

import static ru.yandex.direct.validation.result.PathHelper.emptyPath;

public class AdGroupConverters {

    private AdGroupConverters() {
    }

    public static final PathNodeConverter COMMON_AD_GROUP_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(UntypedAdGroup.ID.name(), GdAddAdGroupMinusKeywordsItem.AD_GROUP_ID.name())
                    .replace(UntypedAdGroup.MINUS_KEYWORDS.name(), GdAddAdGroupMinusKeywordsItem.MINUS_KEYWORDS.name())
                    .build();

    public static final PathNodeConverter UPDATE_AD_GROUP_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(UntypedAdGroup.ID.name(), GdUpdateAdGroupItem.AD_GROUP_ID.name())
                    .replace(UntypedAdGroup.NAME.name(), GdUpdateAdGroupItem.AD_GROUP_NAME.name())
                    .replace(UntypedAdGroup.GEO.name(), GdUpdateAdGroupItem.REGION_IDS.name())
                    .replace(UntypedAdGroup.HYPER_GEO_ID.name(), GdUpdateTextAdGroupItem.HYPER_GEO_ID.name())
                    .replace(UntypedAdGroup.MINUS_KEYWORDS.name(), GdUpdateAdGroupItem.AD_GROUP_MINUS_KEYWORDS.name())
                    .replace(UntypedAdGroup.LIBRARY_MINUS_KEYWORDS_IDS.name(),
                            GdUpdateAdGroupItem.LIBRARY_MINUS_KEYWORDS_IDS.name())
                    .replace(UntypedAdGroup.PAGE_GROUP_TAGS.name(), GdUpdateAdGroupItem.PAGE_GROUP_TAGS.name())
                    .replace(UntypedAdGroup.TARGET_TAGS.name(), GdUpdateAdGroupItem.TARGET_TAGS.name())
                    .build();

    //TODO временное решение, чтобы пофиксить DIRECT-100054
    // В этом тикете сделаем нормально: DIRECT-100074
    @Deprecated
    public static final PathNodeConverter TEMP_UPDATE_AD_GROUP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(AdGroup.class.getName())
                    .replace(UntypedAdGroup.GEO.name(), GdUpdateAdGroupItem.REGION_IDS.name())
                    .build();

    public static final PathNodeConverter UPDATE_TEXT_AD_GROUP_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .keep(ComplexTextAdGroup.KEYWORDS.name())
                    .replace(UntypedAdGroup.ID.name(), GdUpdateAdGroupItem.AD_GROUP_ID.name())
                    .replace(UntypedAdGroup.NAME.name(), GdUpdateAdGroupItem.AD_GROUP_NAME.name())
                    .replace(UntypedAdGroup.GEO.name(), GdUpdateAdGroupItem.REGION_IDS.name())
                    .replace(UntypedAdGroup.HYPER_GEO_ID.name(), GdUpdateTextAdGroupItem.HYPER_GEO_ID.name())
                    .replace(UntypedAdGroup.MINUS_KEYWORDS.name(), GdUpdateAdGroupItem.AD_GROUP_MINUS_KEYWORDS.name())
                    .replace(UntypedAdGroup.LIBRARY_MINUS_KEYWORDS_IDS.name(),
                            GdUpdateAdGroupItem.LIBRARY_MINUS_KEYWORDS_IDS.name())
                    .replace(UntypedAdGroup.PAGE_GROUP_TAGS.name(), GdUpdateAdGroupItem.PAGE_GROUP_TAGS.name())
                    .replace(UntypedAdGroup.TARGET_TAGS.name(), GdUpdateAdGroupItem.TARGET_TAGS.name())
                    .replace(TextAdGroup.FEED_ID.name(), GdUpdateTextAdGroupItem.SMART_FEED_ID.name())
                    .replace(TextAdGroup.FEED_FILTER.name(), GdUpdateTextAdGroupItem.SMART_FEED_FILTER.name())
                    .build();

    public static final PathNodeConverter FEED_FILTER_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(FeedFilter.TAB, GdFeedFilter.TAB)
                    .replace(FeedFilter.CONDITIONS, GdFeedFilter.CONDITIONS)
                    .build();

    public static final PathNodeConverter FEED_FILTER_CONDITION_CONVERTER =
            new PathNodeConverter() {
                private final PathNodeConverter innerConverter = SkipByDefaultMappingPathNodeConverter.builder()
                        .replace(FeedFilterCondition.FIELD_NAME, GdSmartFilterCondition.FIELD)
                        .replace(FeedFilterCondition.OPERATOR, GdSmartFilterCondition.OPERATOR)
                        .replace(FeedFilterCondition.STRING_VALUE, GdSmartFilterCondition.STRING_VALUE)
                        .replace(FeedFilterCondition.PARSED_VALUE, GdSmartFilterCondition.STRING_VALUE.name())
                        .build();

                @Override
                public Path convert(PathNode.Field field) {
                    return innerConverter.convert(field);
                }

                @Override
                public Path convert(PathNode.Field field, PathNode.Index index) {
                    return emptyPath();
                }
            };

    public static final PathNodeConverter UPDATE_PERFORMANCE_AD_GROUP_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(UntypedAdGroup.GEO.name(), GdUpdatePerformanceAdGroupItem.REGION_IDS.name())
                    .build();

    public static final PathNodeConverter ADD_PERFORMANCE_AD_GROUP_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(UntypedAdGroup.NAME.name(), GdUpdateAdGroupItem.AD_GROUP_NAME.name())
                    .build();

    public static final PathNodeConverter VALIDATE_AD_PRICE_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(BannerPrice.PRICE.name(), GdAdPrice.PRICE.name())
                    .replace(BannerPrice.PRICE_OLD.name(), GdAdPrice.PRICE_OLD.name())
                    .replace(BannerPrice.PREFIX.name(), GdAdPrice.PREFIX.name())
                    .replace(BannerPrice.CURRENCY.name(), GdAdPrice.CURRENCY.name())
                    .build();

    public static final PathNodeConverter CONTENT_PROMOTION_AD_GROUP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(ContentPromotionAdGroup.class.getName())
                    .replace(ContentPromotionAdGroup.ID.name(),
                            GdUpdateContentPromotionAdGroupItem.AD_GROUP_ID.name())
                    .replace(ContentPromotionAdGroup.NAME.name(),
                            GdUpdateContentPromotionAdGroupItem.AD_GROUP_NAME.name())
                    .replace(ContentPromotionAdGroup.GEO.name(),
                            GdUpdateContentPromotionAdGroupItem.REGION_IDS.name())
                    .replace(ContentPromotionAdGroup.MINUS_KEYWORDS.name(),
                            GdUpdateContentPromotionAdGroupItem.AD_GROUP_MINUS_KEYWORDS.name())
                    .replace(ContentPromotionAdGroup.LIBRARY_MINUS_KEYWORDS_IDS.name(),
                            GdUpdateContentPromotionAdGroupItem.LIBRARY_MINUS_KEYWORDS_IDS.name())
                    .replace(ContentPromotionAdGroup.PAGE_GROUP_TAGS.name(),
                            GdUpdateContentPromotionAdGroupItem.PAGE_GROUP_TAGS.name())
                    .replace(ContentPromotionAdGroup.TARGET_TAGS.name(),
                            GdUpdateContentPromotionAdGroupItem.TARGET_TAGS.name())
                    .build();

    public static final PathNodeConverter MOBILE_CONTENT_AD_GROUP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(MobileContentAdGroup.class.getName())
                    .replace(MobileContentAdGroup.ID.name(),
                            GdUpdateMobileContentAdGroupItem.AD_GROUP_ID.name())
                    .replace(MobileContentAdGroup.NAME.name(),
                            GdUpdateMobileContentAdGroupItem.AD_GROUP_NAME.name())
                    .replace(MobileContentAdGroup.GEO.name(),
                            GdUpdateMobileContentAdGroupItem.REGION_IDS.name())
                    .replace(MobileContentAdGroup.HYPER_GEO_ID.name(),
                            GdUpdateTextAdGroupItem.HYPER_GEO_ID.name())
                    .replace(MobileContentAdGroup.MINUS_KEYWORDS.name(),
                            GdUpdateMobileContentAdGroupItem.AD_GROUP_MINUS_KEYWORDS.name())
                    .replace(MobileContentAdGroup.LIBRARY_MINUS_KEYWORDS_IDS.name(),
                            GdUpdateMobileContentAdGroupItem.LIBRARY_MINUS_KEYWORDS_IDS.name())
                    .build();
}
