package ru.yandex.direct.grid.processing.service.validation.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.container.UpdateCampMetrikaCountersRequest;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.model.ContentPromotionCampaign;
import ru.yandex.direct.core.entity.campaign.model.DynamicCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalAutobudgetCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalDistribCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalFreeCampaign;
import ru.yandex.direct.core.entity.campaign.model.McBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.campaign.model.SmartCampaign;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.grid.model.campaign.GdCampaign;
import ru.yandex.direct.grid.model.campaign.GdInternalCampaignImpressionFrequencyControl;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddAbstractInternalCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignBiddingStrategy;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignNotificationRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignStrategyData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateAbstractCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateAbstractInternalCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCampaignMetrikaCounters;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateContentPromotionCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateDynamicCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalAutobudgetCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalDistribCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalFreeCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateMcBannerCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateMobileContentCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateSmartCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateTextCampaign;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.result.PathNodeConverter;

import static java.util.Arrays.asList;
import static ru.yandex.direct.validation.result.PathHelper.pathFromStrings;

@SuppressWarnings("java:S3252")
@ParametersAreNonnullByDefault
public class CampaignPathConverters {

    private CampaignPathConverters() {
    }

    public static final PathNodeConverter ADD_AND_UPDATE_TEXT_CAMPAIGN_PATH_CONVERTER = commonPathNodeConverterBuilder()
            .replace(TextCampaign.METRIKA_COUNTERS, GdUpdateTextCampaign.METRIKA_COUNTERS)
            .replace(TextCampaign.HAS_TITLE_SUBSTITUTION, GdUpdateTextCampaign.HAS_TITLE_SUBSTITUTE)
            //notification
            .replace(TextCampaign.ENABLE_CHECK_POSITION_EVENT,
                    toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
            .replace(TextCampaign.CHECK_POSITION_INTERVAL_EVENT,
                    toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
            .replace(TextCampaign.ENABLE_OFFLINE_STAT_NOTICE,
                    toEmailPath(GdCampaignEmailSettingsRequest.XLS_READY))
            .replace(TextCampaign.CONTENT_LANGUAGE, GdUpdateTextCampaign.CONTENT_LANGUAGE)
            .replace(TextCampaign.ALLOWED_PAGE_IDS, GdUpdateTextCampaign.ALLOWED_PAGE_IDS)
            .replace(TextCampaign.ALLOWED_DOMAINS, GdUpdateTextCampaign.ALLOWED_DOMAINS)
            .replace(TextCampaign.ALLOWED_SSP, GdUpdateTextCampaign.ALLOWED_DOMAINS)
            .replace(TextCampaign.DISABLED_DOMAINS, GdUpdateTextCampaign.DISABLED_PLACES)
            .replace(TextCampaign.MEANINGFUL_GOALS.name(), GdUpdateTextCampaign.MEANINGFUL_GOALS.name())
            .replace(TextCampaign.DISABLED_SSP, GdUpdateTextCampaign.DISABLED_PLACES)
            .replace(TextCampaign.PLACEMENT_TYPES, GdUpdateTextCampaign.PLACEMENT_TYPES)
            .replace(TextCampaign.ATTRIBUTION_MODEL, GdUpdateTextCampaign.ATTRIBUTION_MODEL)
            .replace(TextCampaign.HAS_SITE_MONITORING, GdUpdateTextCampaign.HAS_SITE_MONITORING)
            .replace(TextCampaign.HAS_ADD_METRIKA_TAG_TO_URL, GdUpdateTextCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
            .replace(TextCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL, GdUpdateTextCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
            .replace(TextCampaign.BROAD_MATCH, GdUpdateTextCampaign.BROAD_MATCH)
            .replace(TextCampaign.CLIENT_DIALOG_ID, GdUpdateTextCampaign.CLIENT_DIALOG_ID)
            .replace(TextCampaign.MINUS_KEYWORDS, GdUpdateTextCampaign.MINUS_KEYWORDS)
            .replace(TextCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID,
                    GdUpdateTextCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
            .replace(TextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                    GdUpdateTextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
            .replace(TextCampaign.CONTEXT_LIMIT, GdUpdateTextCampaign.CONTEXT_LIMIT)
            .replace(TextCampaign.SECTION_IDS, GdUpdateTextCampaign.SECTION_IDS)
            .replace(TextCampaign.AB_SEGMENT_GOAL_IDS, GdUpdateTextCampaign.AB_SEGMENT_GOAL_IDS)
            .replace(TextCampaign.ENABLE_CPC_HOLD, GdUpdateTextCampaign.ENABLE_CPC_HOLD)
            .replace(TextCampaign.DAY_BUDGET, GdUpdateTextCampaign.DAY_BUDGET)
            .replace(TextCampaign.DAY_BUDGET_SHOW_MODE, GdUpdateTextCampaign.DAY_BUDGET_SHOW_MODE)
            .replace(TextCampaign.DEFAULT_PERMALINK_ID, GdUpdateTextCampaign.DEFAULT_PERMALINK_ID)
            .replace(TextCampaign.DEFAULT_CHAIN_ID, GdUpdateTextCampaign.DEFAULT_CHAIN_ID)
            .replace(TextCampaign.DEFAULT_TRACKING_PHONE_ID, GdUpdateTextCampaign.DEFAULT_TRACKING_PHONE_ID)
            .replace(TextCampaign.ENABLE_COMPANY_INFO, GdUpdateTextCampaign.ENABLE_COMPANY_INFO)
            .replace(TextCampaign.PROMO_EXTENSION_ID, GdUpdateTextCampaign.PROMO_EXTENSION_ID)
            .replace(TextCampaign.HAS_EXTENDED_GEO_TARGETING, GdUpdateTextCampaign.HAS_EXTENDED_GEO_TARGETING)
            .replace(TextCampaign.USE_REGULAR_REGION, GdUpdateTextCampaign.USE_REGULAR_REGION)
            .replace(TextCampaign.USE_CURRENT_REGION, GdUpdateTextCampaign.USE_CURRENT_REGION)
            .replace(TextCampaign.IS_ALONE_TRAFARET_ALLOWED, GdUpdateTextCampaign.IS_ALONE_TRAFARET_ALLOWED)
            .replace(TextCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS,
                    GdUpdateTextCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS)
            .replace(TextCampaign.EXCLUDE_PAUSED_COMPETING_ADS, GdUpdateTextCampaign.EXCLUDE_PAUSED_COMPETING_ADS)
            .replace(TextCampaign.CONTACT_INFO, GdUpdateTextCampaign.VCARD)
            .replace(TextCampaign.STRATEGY, GdUpdateTextCampaign.BIDDING_STATEGY)
            .replace(TextCampaign.BID_MODIFIERS, GdUpdateTextCampaign.BID_MODIFIERS)
            .replace(TextCampaign.BRAND_SAFETY_CATEGORIES, GdUpdateTextCampaign.BRAND_SAFETY_CATEGORIES)
            .replace(TextCampaign.HAS_TURBO_APP, GdUpdateTextCampaign.TURBO_APPS_ENABLED)
            .replace(TextCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED,
                    GdUpdateTextCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
            .replace(TextCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED,
                    GdUpdateTextCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
            .replace(TextCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED,
                    GdUpdateTextCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED)
            .replace(TextCampaign.HREF.name(),
                    asList(GdUpdateTextCampaign.ADDITIONAL_DATA.name(), GdAddUpdateCampaignAdditionalData.HREF.name()))
            .replace(TextCampaign.BANNER_HREF_PARAMS, GdUpdateTextCampaign.BANNER_HREF_PARAMS)
            .replace(TextCampaign.COMPANY_NAME.name(),
                    asList(GdUpdateTextCampaign.ADDITIONAL_DATA.name(),
                            GdAddUpdateCampaignAdditionalData.COMPANY_NAME.name()))
            .replace(TextCampaign.BUSINESS_CATEGORY.name(),
                    asList(GdUpdateTextCampaign.ADDITIONAL_DATA.name(),
                            GdAddUpdateCampaignAdditionalData.BUSINESS_CATEGORY.name()))
            .replace(TextCampaign.IS_UNIVERSAL, GdUpdateTextCampaign.IS_UNIVERSAL_CAMP)
            .replace(TextCampaign.CAMP_AIM_TYPE, GdUpdateTextCampaign.CAMP_AIM_TYPE)
            .replace(TextCampaign.CALLTRACKING_SETTINGS_ID, GdUpdateTextCampaign.CALLTRACKING_SETTINGS_ID)
            .replace(TextCampaign.IS_ALLOWED_ON_ADULT_CONTENT, GdUpdateTextCampaign.IS_ALLOWED_ON_ADULT_CONTENT)
            .replace(TextCampaign.IS_S2S_TRACKING_ENABLED, GdUpdateTextCampaign.IS_S2S_TRACKING_ENABLED)
            .replace(TextCampaign.STRATEGY_ID, GdUpdateTextCampaign.STRATEGY_ID)
            .build();

    public static final PathNodeConverter ADD_AND_UPDATE_DYNAMIC_CAMPAIGN_PATH_CONVERTER =
            commonPathNodeConverterBuilder()
                    .replace(DynamicCampaign.METRIKA_COUNTERS, GdUpdateDynamicCampaign.METRIKA_COUNTERS)
                    .replace(DynamicCampaign.HAS_TITLE_SUBSTITUTION, GdUpdateDynamicCampaign.HAS_TITLE_SUBSTITUTE)
                    //notification
                    .replace(DynamicCampaign.ENABLE_CHECK_POSITION_EVENT,
                            toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
                    .replace(DynamicCampaign.CHECK_POSITION_INTERVAL_EVENT,
                            toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
                    .replace(DynamicCampaign.ENABLE_OFFLINE_STAT_NOTICE,
                            toEmailPath(GdCampaignEmailSettingsRequest.XLS_READY))
                    .replace(DynamicCampaign.CONTENT_LANGUAGE, GdUpdateDynamicCampaign.CONTENT_LANGUAGE)
                    .replace(DynamicCampaign.ALLOWED_PAGE_IDS, GdUpdateDynamicCampaign.ALLOWED_PAGE_IDS)
                    .replace(DynamicCampaign.ALLOWED_DOMAINS, GdUpdateDynamicCampaign.ALLOWED_DOMAINS)
                    .replace(DynamicCampaign.ALLOWED_SSP, GdUpdateTextCampaign.ALLOWED_DOMAINS)
                    .replace(DynamicCampaign.DISABLED_DOMAINS, GdUpdateDynamicCampaign.DISABLED_PLACES)
                    .replace(DynamicCampaign.MEANINGFUL_GOALS, GdUpdateDynamicCampaign.MEANINGFUL_GOALS)
                    .replace(DynamicCampaign.DISABLED_SSP, GdUpdateDynamicCampaign.DISABLED_PLACES)
                    .replace(DynamicCampaign.PLACEMENT_TYPES, GdUpdateDynamicCampaign.PLACEMENT_TYPES)
                    .replace(DynamicCampaign.ATTRIBUTION_MODEL, GdUpdateDynamicCampaign.ATTRIBUTION_MODEL)
                    .replace(DynamicCampaign.HAS_SITE_MONITORING, GdUpdateDynamicCampaign.HAS_SITE_MONITORING)
                    .replace(DynamicCampaign.HAS_ADD_METRIKA_TAG_TO_URL,
                            GdUpdateDynamicCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                    .replace(DynamicCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL,
                            GdUpdateDynamicCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                    .replace(DynamicCampaign.MINUS_KEYWORDS, GdUpdateDynamicCampaign.MINUS_KEYWORDS)
                    .replace(DynamicCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID,
                            GdUpdateDynamicCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                    .replace(DynamicCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                            GdUpdateDynamicCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                    .replace(DynamicCampaign.SECTION_IDS, GdUpdateDynamicCampaign.SECTION_IDS)
                    .replace(DynamicCampaign.AB_SEGMENT_GOAL_IDS, GdUpdateDynamicCampaign.AB_SEGMENT_GOAL_IDS)
                    .replace(DynamicCampaign.ENABLE_CPC_HOLD, GdUpdateDynamicCampaign.ENABLE_CPC_HOLD)
                    .replace(DynamicCampaign.DAY_BUDGET, GdUpdateDynamicCampaign.DAY_BUDGET)
                    .replace(DynamicCampaign.DAY_BUDGET_SHOW_MODE, GdUpdateDynamicCampaign.DAY_BUDGET_SHOW_MODE)
                    .replace(DynamicCampaign.DEFAULT_PERMALINK_ID, GdUpdateDynamicCampaign.DEFAULT_PERMALINK_ID)
                    .replace(DynamicCampaign.ENABLE_COMPANY_INFO, GdUpdateDynamicCampaign.ENABLE_COMPANY_INFO)
                    .replace(DynamicCampaign.PROMO_EXTENSION_ID, GdUpdateDynamicCampaign.PROMO_EXTENSION_ID)
                    .replace(DynamicCampaign.HAS_EXTENDED_GEO_TARGETING,
                            GdUpdateDynamicCampaign.HAS_EXTENDED_GEO_TARGETING)
                    .replace(DynamicCampaign.USE_CURRENT_REGION,
                            GdUpdateDynamicCampaign.USE_CURRENT_REGION)
                    .replace(DynamicCampaign.USE_REGULAR_REGION,
                            GdUpdateDynamicCampaign.USE_REGULAR_REGION)
                    .replace(DynamicCampaign.IS_ALONE_TRAFARET_ALLOWED,
                            GdUpdateDynamicCampaign.IS_ALONE_TRAFARET_ALLOWED)
                    .replace(DynamicCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS,
                            GdUpdateDynamicCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS)
                    .replace(DynamicCampaign.CONTACT_INFO, GdUpdateDynamicCampaign.VCARD)
                    .replace(DynamicCampaign.STRATEGY, GdUpdateDynamicCampaign.BIDDING_STATEGY)
                    .replace(DynamicCampaign.BID_MODIFIERS, GdUpdateDynamicCampaign.BID_MODIFIERS)
                    .replace(DynamicCampaign.BRAND_SAFETY_CATEGORIES, GdUpdateDynamicCampaign.BRAND_SAFETY_CATEGORIES)
                    .replace(DynamicCampaign.HAS_TURBO_APP, GdUpdateDynamicCampaign.TURBO_APPS_ENABLED)
                    .replace(DynamicCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED,
                            GdUpdateDynamicCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED)
                    .replace(DynamicCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED,
                            GdUpdateDynamicCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                    .replace(DynamicCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED,
                            GdUpdateDynamicCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                    .replace(DynamicCampaign.HREF.name(), asList(
                            GdUpdateDynamicCampaign.ADDITIONAL_DATA.name(),
                            GdAddUpdateCampaignAdditionalData.HREF.name()))
                    .replace(DynamicCampaign.BANNER_HREF_PARAMS, GdUpdateDynamicCampaign.BANNER_HREF_PARAMS)
                    .replace(DynamicCampaign.IS_S2S_TRACKING_ENABLED, GdUpdateDynamicCampaign.IS_S2S_TRACKING_ENABLED)
                    .replace(DynamicCampaign.STRATEGY_ID, GdUpdateDynamicCampaign.STRATEGY_ID)
                    .build();

    public static final PathNodeConverter ADD_AND_UPDATE_SMART_CAMPAIGN_PATH_CONVERTER =
            commonPathNodeConverterBuilder()
                    .replace(SmartCampaign.METRIKA_COUNTERS, GdUpdateSmartCampaign.METRIKA_COUNTERS)
                    .replace(SmartCampaign.ENABLE_OFFLINE_STAT_NOTICE,
                            toEmailPath(GdCampaignEmailSettingsRequest.XLS_READY))
                    .replace(SmartCampaign.CONTENT_LANGUAGE, GdUpdateSmartCampaign.CONTENT_LANGUAGE)
                    .replace(SmartCampaign.DISABLED_DOMAINS, GdUpdateSmartCampaign.DISABLED_PLACES)
                    .replace(SmartCampaign.MEANINGFUL_GOALS, GdUpdateSmartCampaign.MEANINGFUL_GOALS)
                    .replace(SmartCampaign.DISABLED_SSP, GdUpdateSmartCampaign.DISABLED_PLACES)
                    .replace(SmartCampaign.ATTRIBUTION_MODEL, GdUpdateSmartCampaign.ATTRIBUTION_MODEL)
                    .replace(SmartCampaign.HAS_ADD_METRIKA_TAG_TO_URL, GdUpdateSmartCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                    .replace(SmartCampaign.HAS_EXTENDED_GEO_TARGETING, GdUpdateSmartCampaign.HAS_EXTENDED_GEO_TARGETING)
                    .replace(SmartCampaign.USE_CURRENT_REGION, GdUpdateSmartCampaign.USE_CURRENT_REGION)
                    .replace(SmartCampaign.USE_REGULAR_REGION, GdUpdateSmartCampaign.USE_REGULAR_REGION)
                    .replace(SmartCampaign.MINUS_KEYWORDS, GdUpdateSmartCampaign.MINUS_KEYWORDS)
                    .replace(SmartCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID,
                            GdUpdateSmartCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                    .replace(SmartCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                            GdUpdateSmartCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                    .replace(SmartCampaign.CONTEXT_LIMIT, GdUpdateSmartCampaign.CONTEXT_LIMIT)
                    .replace(SmartCampaign.SECTION_IDS, GdUpdateSmartCampaign.SECTION_IDS)
                    .replace(SmartCampaign.AB_SEGMENT_GOAL_IDS, GdUpdateSmartCampaign.AB_SEGMENT_GOAL_IDS)
                    .replace(SmartCampaign.IS_ALONE_TRAFARET_ALLOWED, GdUpdateSmartCampaign.IS_ALONE_TRAFARET_ALLOWED)
                    .replace(SmartCampaign.HAS_TURBO_SMARTS, GdUpdateSmartCampaign.HAS_TURBO_SMARTS)
                    .replace(SmartCampaign.STRATEGY, GdUpdateSmartCampaign.BIDDING_STRATEGY)
                    .replace(SmartCampaign.BID_MODIFIERS, GdUpdateSmartCampaign.BID_MODIFIERS)
                    .replace(SmartCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS,
                            GdUpdateSmartCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS)
                    .replace(SmartCampaign.BRAND_SAFETY_CATEGORIES, GdUpdateSmartCampaign.BRAND_SAFETY_CATEGORIES)
                    .replace(SmartCampaign.HAS_TURBO_APP, GdUpdateSmartCampaign.TURBO_APPS_ENABLED)
                    .replace(SmartCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED,
                            GdUpdateSmartCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED)
                    .replace(SmartCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED,
                            GdUpdateSmartCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                    .replace(SmartCampaign.HREF.name(), asList(
                            GdUpdateSmartCampaign.ADDITIONAL_DATA.name(),
                            GdAddUpdateCampaignAdditionalData.HREF.name()))
                    .replace(SmartCampaign.BANNER_HREF_PARAMS, GdUpdateSmartCampaign.BANNER_HREF_PARAMS)
                    .replace(SmartCampaign.IS_S2S_TRACKING_ENABLED, GdUpdateSmartCampaign.IS_S2S_TRACKING_ENABLED)
                    .replace(SmartCampaign.STRATEGY_ID, GdUpdateSmartCampaign.STRATEGY_ID)
                    .replace(SmartCampaign.IS_WW_MANAGED_ORDER, GdUpdateSmartCampaign.IS_WW_MANAGED_ORDER)
                    .build();

    public static final PathNodeConverter ADD_AND_UPDATE_MOBILE_CONTENT_CAMPAIGN_PATH_CONVERTER =
            commonPathNodeConverterBuilder()
                    .replace(MobileContentCampaign.ENABLE_CHECK_POSITION_EVENT,
                            toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
                    .replace(MobileContentCampaign.CHECK_POSITION_INTERVAL_EVENT,
                            toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
                    .replace(MobileContentCampaign.ENABLE_OFFLINE_STAT_NOTICE,
                            toEmailPath(GdCampaignEmailSettingsRequest.XLS_READY))
                    .replace(MobileContentCampaign.CONTENT_LANGUAGE, GdUpdateMobileContentCampaign.CONTENT_LANGUAGE)
                    .replace(MobileContentCampaign.ALLOWED_PAGE_IDS, GdUpdateMobileContentCampaign.ALLOWED_PAGE_IDS)
                    .replace(MobileContentCampaign.ALLOWED_DOMAINS, GdUpdateMobileContentCampaign.ALLOWED_DOMAINS)
                    .replace(MobileContentCampaign.ALLOWED_SSP, GdUpdateMobileContentCampaign.ALLOWED_DOMAINS)
                    .replace(MobileContentCampaign.DISABLED_DOMAINS, GdUpdateMobileContentCampaign.DISABLED_PLACES)
                    .replace(MobileContentCampaign.DISABLED_SSP, GdUpdateMobileContentCampaign.DISABLED_PLACES)
                    .replace(MobileContentCampaign.MINUS_KEYWORDS, GdUpdateMobileContentCampaign.MINUS_KEYWORDS)
                    .replace(MobileContentCampaign.CONTEXT_LIMIT, GdUpdateMobileContentCampaign.CONTEXT_LIMIT)
                    .replace(MobileContentCampaign.ENABLE_CPC_HOLD, GdUpdateMobileContentCampaign.ENABLE_CPC_HOLD)
                    .replace(MobileContentCampaign.DAY_BUDGET, GdUpdateMobileContentCampaign.DAY_BUDGET)
                    .replace(MobileContentCampaign.DAY_BUDGET_SHOW_MODE,
                            GdUpdateMobileContentCampaign.DAY_BUDGET_SHOW_MODE)
                    .replace(MobileContentCampaign.HAS_EXTENDED_GEO_TARGETING,
                            GdUpdateMobileContentCampaign.HAS_EXTENDED_GEO_TARGETING)
                    .replace(MobileContentCampaign.USE_REGULAR_REGION, GdUpdateMobileContentCampaign.USE_REGULAR_REGION)
                    .replace(MobileContentCampaign.USE_CURRENT_REGION, GdUpdateMobileContentCampaign.USE_CURRENT_REGION)
                    .replace(MobileContentCampaign.IS_ALONE_TRAFARET_ALLOWED,
                            GdUpdateMobileContentCampaign.IS_ALONE_TRAFARET_ALLOWED)
                    .replace(MobileContentCampaign.STRATEGY, GdUpdateMobileContentCampaign.BIDDING_STRATEGY)
                    .replace(MobileContentCampaign.BRAND_SAFETY_CATEGORIES,
                            GdUpdateMobileContentCampaign.BRAND_SAFETY_CATEGORIES)
                    .replace(MobileContentCampaign.DEVICE_TYPE_TARGETING,
                            GdUpdateMobileContentCampaign.DEVICE_TYPE_TARGETING)
                    .replace(MobileContentCampaign.NETWORK_TARGETING, GdUpdateMobileContentCampaign.NETWORK_TARGETING)
                    .replace(MobileContentCampaign.IS_INSTALLED_APP, GdUpdateMobileContentCampaign.IS_INSTALLED_APP)
                    .replace(MobileContentCampaign.MOBILE_APP_ID, GdUpdateMobileContentCampaign.MOBILE_APP_ID)
                    .replace(MobileContentCampaign.HREF.name(), asList(
                            GdUpdateMobileContentCampaign.ADDITIONAL_DATA.name(),
                            GdAddUpdateCampaignAdditionalData.HREF.name()))
                    .replace(MobileContentCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED,
                            GdUpdateMobileContentCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                    .replace(MobileContentCampaign.IS_NEW_IOS_VERSION_ENABLED,
                            GdUpdateMobileContentCampaign.IS_NEW_IOS_VERSION_ENABLED)
                    .replace(MobileContentCampaign.IS_SKAD_NETWORK_ENABLED,
                            GdUpdateMobileContentCampaign.IS_SKAD_NETWORK_ENABLED)
                    .replace(MobileContentCampaign.STRATEGY_ID, GdUpdateMobileContentCampaign.STRATEGY_ID)
                    .build();

    public static final PathNodeConverter ADD_AND_UPDATE_MCBANNER_CAMPAIGN_PATH_CONVERTER =
            commonPathNodeConverterBuilder()
                    .replace(McBannerCampaign.METRIKA_COUNTERS, GdUpdateMcBannerCampaign.METRIKA_COUNTERS)
                    .replace(McBannerCampaign.ENABLE_OFFLINE_STAT_NOTICE,
                            toEmailPath(GdCampaignEmailSettingsRequest.XLS_READY))
                    .replace(McBannerCampaign.CONTENT_LANGUAGE, GdUpdateMcBannerCampaign.CONTENT_LANGUAGE)
                    .replace(McBannerCampaign.DISABLED_DOMAINS, GdUpdateMcBannerCampaign.DISABLED_PLACES)
                    .replace(McBannerCampaign.MEANINGFUL_GOALS.name(), GdUpdateMcBannerCampaign.MEANINGFUL_GOALS.name())
                    .replace(McBannerCampaign.DISABLED_SSP, GdUpdateMcBannerCampaign.DISABLED_PLACES)
                    .replace(McBannerCampaign.HAS_SITE_MONITORING, GdUpdateMcBannerCampaign.HAS_SITE_MONITORING)
                    .replace(McBannerCampaign.HAS_ADD_METRIKA_TAG_TO_URL,
                            GdUpdateMcBannerCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                    .replace(McBannerCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL,
                            GdUpdateMcBannerCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                    .replace(McBannerCampaign.MINUS_KEYWORDS, GdUpdateMcBannerCampaign.MINUS_KEYWORDS)
                    .replace(McBannerCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID,
                            GdUpdateMcBannerCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                    .replace(McBannerCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                            GdUpdateMcBannerCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                    .replace(McBannerCampaign.CONTEXT_LIMIT, GdUpdateMcBannerCampaign.CONTEXT_LIMIT)
                    .replace(McBannerCampaign.SECTION_IDS, GdUpdateMcBannerCampaign.SECTION_IDS)
                    .replace(McBannerCampaign.AB_SEGMENT_GOAL_IDS, GdUpdateMcBannerCampaign.AB_SEGMENT_GOAL_IDS)
                    .replace(McBannerCampaign.ENABLE_CPC_HOLD, GdUpdateMcBannerCampaign.ENABLE_CPC_HOLD)
                    .replace(McBannerCampaign.DAY_BUDGET, GdUpdateMcBannerCampaign.DAY_BUDGET)
                    .replace(McBannerCampaign.DAY_BUDGET_SHOW_MODE, GdUpdateMcBannerCampaign.DAY_BUDGET_SHOW_MODE)
                    .replace(McBannerCampaign.HAS_EXTENDED_GEO_TARGETING,
                            GdUpdateMcBannerCampaign.HAS_EXTENDED_GEO_TARGETING)
                    .replace(McBannerCampaign.USE_REGULAR_REGION, GdUpdateMcBannerCampaign.USE_REGULAR_REGION)
                    .replace(McBannerCampaign.USE_CURRENT_REGION, GdUpdateMcBannerCampaign.USE_CURRENT_REGION)
                    .replace(McBannerCampaign.STRATEGY, GdUpdateMcBannerCampaign.BIDDING_STRATEGY)
                    .replace(McBannerCampaign.BID_MODIFIERS, GdUpdateMcBannerCampaign.BID_MODIFIERS)
                    .replace(McBannerCampaign.BRAND_SAFETY_CATEGORIES, GdUpdateMcBannerCampaign.BRAND_SAFETY_CATEGORIES)
                    .replace(McBannerCampaign.HREF.name(), asList(
                            GdUpdateMcBannerCampaign.ADDITIONAL_DATA.name(),
                            GdAddUpdateCampaignAdditionalData.HREF.name()))
                    .replace(McBannerCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED,
                            GdUpdateMcBannerCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                    .replace(McBannerCampaign.STRATEGY_ID, GdUpdateMcBannerCampaign.STRATEGY_ID)
                    .build();

    public static final PathNodeConverter ADD_AND_UPDATE_AUTOBUDGET_CAMPAIGN_PATH_CONVERTER =
            commonInternalCampaignsPathNodeConverterBuilder()
                    .replace(InternalAutobudgetCampaign.STRATEGY, GdUpdateInternalAutobudgetCampaign.BIDDING_STATEGY)
                    .replace(InternalAutobudgetCampaign.ROTATION_GOAL_ID, toStrategyGoalIdPath())
                    .build();

    public static final PathNodeConverter ADD_AND_UPDATE_CONTENT_PROMOTION_CAMPAIGN_PATH_CONVERTER =
            commonPathNodeConverterBuilder()
                    .replace(ContentPromotionCampaign.METRIKA_COUNTERS,
                            GdUpdateContentPromotionCampaign.METRIKA_COUNTERS)
                    //notification
                    .replace(ContentPromotionCampaign.CONTENT_LANGUAGE,
                            GdUpdateContentPromotionCampaign.CONTENT_LANGUAGE)
                    .replace(ContentPromotionCampaign.ATTRIBUTION_MODEL,
                            GdUpdateContentPromotionCampaign.ATTRIBUTION_MODEL)
                    .replace(ContentPromotionCampaign.MINUS_KEYWORDS, GdUpdateContentPromotionCampaign.MINUS_KEYWORDS)
                    .replace(ContentPromotionCampaign.DAY_BUDGET, GdUpdateContentPromotionCampaign.DAY_BUDGET)
                    .replace(ContentPromotionCampaign.DAY_BUDGET_SHOW_MODE,
                            GdUpdateContentPromotionCampaign.DAY_BUDGET_SHOW_MODE)
                    .replace(ContentPromotionCampaign.HAS_EXTENDED_GEO_TARGETING,
                            GdUpdateContentPromotionCampaign.HAS_EXTENDED_GEO_TARGETING)
                    .replace(ContentPromotionCampaign.USE_REGULAR_REGION,
                            GdUpdateContentPromotionCampaign.USE_REGULAR_REGION)
                    .replace(ContentPromotionCampaign.USE_CURRENT_REGION,
                            GdUpdateContentPromotionCampaign.USE_CURRENT_REGION)
                    .replace(ContentPromotionCampaign.STRATEGY, GdUpdateContentPromotionCampaign.BIDDING_STATEGY)
                    .replace(ContentPromotionCampaign.BID_MODIFIERS, GdUpdateContentPromotionCampaign.BID_MODIFIERS)
                    .replace(ContentPromotionCampaign.BRAND_SAFETY_CATEGORIES,
                            GdUpdateContentPromotionCampaign.BRAND_SAFETY_CATEGORIES)
                    .replace(ContentPromotionCampaign.HREF.name(), asList(
                            GdUpdateContentPromotionCampaign.ADDITIONAL_DATA.name(),
                            GdAddUpdateCampaignAdditionalData.HREF.name()))
                    .replace(ContentPromotionCampaign.STRATEGY_ID, GdUpdateContentPromotionCampaign.STRATEGY_ID)
                    .build();

    public static final PathNodeConverter ADD_AND_UPDATE_DISTRIB_CAMPAIGN_PATH_CONVERTER =
            commonInternalCampaignsPathNodeConverterBuilder()
                    .replace(InternalDistribCampaign.ROTATION_GOAL_ID, GdUpdateInternalDistribCampaign.ROTATION_GOAL_ID)
                    .build();

    public static final PathNodeConverter ADD_AND_UPDATE_FREE_CAMPAIGN_PATH_CONVERTER =
            commonInternalCampaignsPathNodeConverterBuilder()
                    .replace(InternalFreeCampaign.RESTRICTION_VALUE, GdUpdateInternalFreeCampaign.RESTRICTION_VALUE)
                    .replace(InternalFreeCampaign.RESTRICTION_TYPE, GdUpdateInternalFreeCampaign.RESTRICTION_TYPE)
                    .build();

    public static final PathNodeConverter UPDATE_CAMPAIGN_METRIKA_COUNTERS_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(UpdateCampMetrikaCountersRequest.CIDS, GdUpdateCampaignMetrikaCounters.CAMPAIGN_IDS)
                    .replace(UpdateCampMetrikaCountersRequest.METRIKA_COUNTERS,
                            GdUpdateCampaignMetrikaCounters.METRIKA_COUNTERS)
                    .build();

    private static SkipByDefaultMappingPathNodeConverter.Builder commonPathNodeConverterBuilder() {
        return SkipByDefaultMappingPathNodeConverter.builder()
                .replace(CommonCampaign.ID, GdUpdateAbstractCampaign.ID)
                .replace(CommonCampaign.NAME, GdUpdateAbstractCampaign.NAME)
                .replace(CommonCampaign.START_DATE, GdUpdateAbstractCampaign.START_DATE)
                .replace(CommonCampaign.END_DATE, GdUpdateAbstractCampaign.END_DATE)
                .replace(CommonCampaign.DISABLED_IPS, GdUpdateAbstractCampaign.DISABLED_IPS)
                .replace(CommonCampaign.TIME_TARGET, GdUpdateAbstractCampaign.TIME_TARGET)
                .replace(CommonCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED,
                        GdUpdateAbstractCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .replace(CommonCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED,
                        GdUpdateAbstractCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)

                //notification
                .replace(CommonCampaign.EMAIL, toEmailPath(GdCampaignEmailSettingsRequest.EMAIL))
                .replace(CommonCampaign.WARNING_BALANCE, toEmailPath(GdCampaignEmailSettingsRequest.WARNING_BALANCE))
                .replace(CommonCampaign.ENABLE_SEND_ACCOUNT_NEWS,
                        toEmailPath(GdCampaignEmailSettingsRequest.SEND_ACCOUNT_NEWS))
                .replace(CommonCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT,
                        toEmailPath(GdCampaignEmailSettingsRequest.STOP_BY_REACH_DAILY_BUDGET))
                .replace(CommonCampaign.SMS_TIME, toSmsPath(GdCampaignSmsSettingsRequest.SMS_TIME))
                .replace(CommonCampaign.SMS_FLAGS, toSmsPath(GdCampaignSmsSettingsRequest.ENABLE_EVENTS));
    }

    private static SkipByDefaultMappingPathNodeConverter.Builder commonInternalCampaignsPathNodeConverterBuilder() {
        return commonPathNodeConverterBuilder()
                .replace(InternalCampaign.IS_MOBILE, GdAddAbstractInternalCampaign.IS_MOBILE)
                .replace(InternalCampaign.PLACE_ID, GdAddAbstractInternalCampaign.PLACE_ID)
                .replace(InternalCampaign.PAGE_ID, GdAddAbstractInternalCampaign.PAGE_ID)
                .replace(InternalCampaign.IMPRESSION_RATE_COUNT,
                        toImpressionFrequencyControlPath(GdInternalCampaignImpressionFrequencyControl.IMPRESSIONS))
                .replace(InternalCampaign.IMPRESSION_RATE_INTERVAL_DAYS,
                        toImpressionFrequencyControlPath(GdInternalCampaignImpressionFrequencyControl.DAYS))
                .replace(InternalCampaign.MAX_CLICKS_COUNT,
                        toImpressionFrequencyControlPath(GdInternalCampaignImpressionFrequencyControl.MAX_CLICKS_COUNT))
                .replace(InternalCampaign.MAX_CLICKS_PERIOD,
                        toImpressionFrequencyControlPath(GdInternalCampaignImpressionFrequencyControl.MAX_CLICKS_PERIOD))
                .replace(InternalCampaign.MAX_STOPS_COUNT,
                        toImpressionFrequencyControlPath(GdInternalCampaignImpressionFrequencyControl.MAX_STOPS_COUNT))
                .replace(InternalCampaign.MAX_STOPS_PERIOD,
                        toImpressionFrequencyControlPath(GdInternalCampaignImpressionFrequencyControl.MAX_STOPS_PERIOD))

                .replace(InternalAutobudgetCampaign.METRIKA_COUNTERS, GdUpdateAbstractInternalCampaign.METRIKA_COUNTERS)
                .replace(InternalAutobudgetCampaign.MEANINGFUL_GOALS.name(),
                        GdUpdateAbstractInternalCampaign.MEANINGFUL_GOALS.name())
                .replace(InternalAutobudgetCampaign.ENABLE_CHECK_POSITION_EVENT,
                        toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
                .replace(InternalAutobudgetCampaign.CHECK_POSITION_INTERVAL_EVENT,
                        toEmailPath(GdCampaignEmailSettingsRequest.CHECK_POSITION_INTERVAL))
                .replace(InternalAutobudgetCampaign.ENABLE_OFFLINE_STAT_NOTICE,
                        toEmailPath(GdCampaignEmailSettingsRequest.XLS_READY))
                .replace(InternalAutobudgetCampaign.ATTRIBUTION_MODEL,
                        GdUpdateAbstractInternalCampaign.ATTRIBUTION_MODEL)

                .replace(InternalCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID,
                        GdUpdateTextCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .replace(InternalCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                        GdUpdateTextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .replace(InternalCampaign.SECTION_IDS, GdAddAbstractInternalCampaign.SECTION_IDS)
                .replace(InternalCampaign.AB_SEGMENT_GOAL_IDS, GdAddAbstractInternalCampaign.AB_SEGMENT_GOAL_IDS);
    }

    private static String toEmailPath(ModelProperty<?, ?> property) {
        return pathFromStrings(GdCampaign.NOTIFICATION.name(),
                GdCampaignNotificationRequest.EMAIL_SETTINGS.name(), property.name()).toString();
    }

    private static String toSmsPath(ModelProperty<?, ?> property) {
        return pathFromStrings(GdCampaign.NOTIFICATION.name(),
                GdCampaignNotificationRequest.SMS_SETTINGS.name(), property.name()).toString();
    }

    private static String toImpressionFrequencyControlPath(ModelProperty<?, ?> property) {
        return pathFromStrings(GdUpdateAbstractInternalCampaign.IMPRESSION_FREQUENCY_CONTROL.name(),
                property.name()).toString();
    }

    private static String toStrategyGoalIdPath() {
        return pathFromStrings(GdUpdateInternalAutobudgetCampaign.BIDDING_STATEGY.name(),
                GdCampaignBiddingStrategy.STRATEGY_DATA.name(),
                GdCampaignStrategyData.GOAL_ID.name()).toString();
    }

}
