package ru.yandex.direct.grid.processing.service.validation.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.time.model.TimeInterval;
import ru.yandex.direct.grid.model.GdTime;
import ru.yandex.direct.grid.model.GdTimeInterval;
import ru.yandex.direct.validation.result.PathNodeConverter;

import static ru.yandex.direct.validation.result.PathHelper.pathFromStrings;

@ParametersAreNonnullByDefault
public class TimePathConverters {

    private TimePathConverters() {
    }

    public static final PathNodeConverter TIME_INTERVAL_PATH_CONVERTER = SkipByDefaultMappingPathNodeConverter.builder()
            .replace(TimeInterval.START_HOUR,
                    pathFromStrings(GdTimeInterval.START_TIME.name(), GdTime.HOUR.name()).toString())
            .replace(TimeInterval.START_MINUTE,
                    pathFromStrings(GdTimeInterval.START_TIME.name(), GdTime.MINUTE.name()).toString())
            .replace(TimeInterval.END_HOUR,
                    pathFromStrings(GdTimeInterval.END_TIME.name(), GdTime.HOUR.name()).toString())
            .replace(TimeInterval.END_MINUTE,
                    pathFromStrings(GdTimeInterval.END_TIME.name(), GdTime.MINUTE.name()).toString())
            .build();

}
