package ru.yandex.direct.grid.processing.service.validation.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.vcard.model.InstantMessenger;
import ru.yandex.direct.core.entity.vcard.model.Phone;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.grid.processing.model.cliententity.vcard.GdInstantMessenger;
import ru.yandex.direct.grid.processing.model.cliententity.vcard.GdPhone;
import ru.yandex.direct.grid.processing.model.cliententity.vcard.mutation.GdAddAddress;
import ru.yandex.direct.grid.processing.model.cliententity.vcard.mutation.GdAddVcard;
import ru.yandex.direct.validation.result.PathNodeConverter;

import static ru.yandex.direct.validation.result.PathHelper.pathFromStrings;

@ParametersAreNonnullByDefault
public class VcardPathConverters {

    private VcardPathConverters() {
    }

    public static final PathNodeConverter VCARD_PATH_CONVERTER = SkipByDefaultMappingPathNodeConverter.builder()
            .replace(Vcard.OGRN.name(), GdAddVcard.OGRN.name())
            .replace(Vcard.CAMPAIGN_ID.name(), GdAddVcard.CAMPAIGN_ID.name())
            .replace(Vcard.EXTRA_MESSAGE.name(), GdAddVcard.EXTRA_MESSAGE.name())
            .replace(Vcard.EMAIL.name(), GdAddVcard.EMAIL.name())
            .replace(Vcard.COMPANY_NAME.name(), GdAddVcard.COMPANY_NAME.name())
            .replace(Vcard.CONTACT_PERSON.name(), GdAddVcard.CONTACT_PERSON.name())
            .replace(Vcard.WORK_TIME.name(), GdAddVcard.WORK_TIMES.name())

            //instantMessenger
            .replace(Vcard.INSTANT_MESSENGER.name(), GdAddVcard.INSTANT_MESSENGER.name())
            .replace(InstantMessenger.TYPE.name(), GdInstantMessenger.TYPE.name())
            .replace(InstantMessenger.LOGIN.name(), GdInstantMessenger.LOGIN.name())

            //address
            .replace(Vcard.COUNTRY.name(), toAddressPath(GdAddAddress.COUNTRY.name()))
            .replace(Vcard.CITY.name(), toAddressPath(GdAddAddress.CITY.name()))
            .replace(Vcard.STREET.name(), toAddressPath(GdAddAddress.STREET.name()))
            .replace(Vcard.HOUSE.name(), toAddressPath(GdAddAddress.HOUSE_WITH_BUILDING.name()))
            .replace(Vcard.BUILD.name(), toAddressPath(GdAddAddress.HOUSE_WITH_BUILDING.name()))
            .replace(Vcard.APART.name(), toAddressPath(GdAddAddress.APARTMENT.name()))
            .replace(Vcard.METRO_ID.name(), toAddressPath(GdAddAddress.METRO_STATION_ID.name()))
            .replace(Vcard.MANUAL_POINT.name(), toAddressPath(GdAddAddress.POINT_ON_MAP.name()))

            //phone
            .replace(Vcard.PHONE.name(), GdAddVcard.PHONE.name())
            .replace(Phone.PHONE_NUMBER.name(), GdPhone.PHONE_NUMBER.name())
            .replace(Phone.CITY_CODE.name(), GdPhone.CITY_CODE.name())
            .replace(Phone.COUNTRY_CODE.name(), GdPhone.COUNTRY_CODE.name())
            .replace(Phone.EXTENSION.name(), GdPhone.EXTENSION.name())

            .build();

    private static String toAddressPath(String fieldName) {
        return pathFromStrings(GdAddVcard.ADDRESS.name(), fieldName).toString();
    }

}
