package ru.yandex.direct.grid.processing.service.welcome;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;

import ru.yandex.direct.grid.processing.annotations.PublicGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.welcome.GdGetWelcomePageDataPayload;

@PublicGraphQLService
@ParametersAreNonnullByDefault
public class WelcomePageGraphQlService {

    private final WelcomePageDataService welcomePageDataService;

    public WelcomePageGraphQlService(WelcomePageDataService welcomePageDataService) {
        this.welcomePageDataService = welcomePageDataService;
    }

    /**
     * Возвращает данные для страницы регистрации клиента в Директе
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "welcomePageData")
    public GdGetWelcomePageDataPayload getWelcomePageData(@GraphQLRootContext GridGraphQLContext context) {
        return welcomePageDataService.getWelcomePageData(context.getOperator());
    }
}
