package ru.yandex.direct.grid.processing.util;

import java.net.IDN;
import java.net.URL;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaviconUtils {
    private static final Logger logger = LoggerFactory.getLogger(FaviconUtils.class);
    private static final Pattern SLASHES_AT_THE_BEGINNING_PATTERN = Pattern.compile("^/+");
    private static final Pattern SLASHES_AT_THE_END_PATTERN = Pattern.compile("/+$");

    public static String getFaviconLink(String domain) {
        if (StringUtils.isBlank(domain)) {
            return null;
        }
        String preparedDomain = trimTrailingSlashes(domain) + "/";
        try {
            URL url = new URL("https://" + preparedDomain);
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setScheme(null);
            uriBuilder.clearParameters();
            uriBuilder.setFragment(null);
            uriBuilder.setHost(IDN.toASCII(url.getHost().toLowerCase()));
            uriBuilder.setPort(-1);
            preparedDomain = trimTrailingSlashes(uriBuilder.toString()) + "/";
            //preparedDomain = URLEncoder.encode(preparedDomain, "UTF-8"); нужно эскейпить только опредедённые символы,
            // сделаю позже
        } catch (Exception e) {
            logger.warn("error preparing href to get favicon link: ", e);
        }
        return "https://favicon.yandex.net/favicon/v2/https://" + preparedDomain + "?size=32&stub=1";
    }

    private static String trimTrailingSlashes(String input) {
        String result = input;
        result = SLASHES_AT_THE_BEGINNING_PATTERN.matcher(result).replaceAll("");
        result = SLASHES_AT_THE_END_PATTERN.matcher(result).replaceAll("");
        return result;
    }
}
