package ru.yandex.direct.grid.processing.util;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.grid.processing.model.api.GdDefect;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;

public class GdValidationResultUtils {

    @Nullable
    public static GdValidationResult concatValidationResults(GdValidationResult... validationResults) {
        var nonNullResults = StreamEx.of(validationResults).nonNull().toList();
        if (nonNullResults.isEmpty()) {
            return null;
        }

        List<GdDefect> errors = new ArrayList<>();
        List<GdDefect> warnings = new ArrayList<>();

        StreamEx.of(nonNullResults).forEach(r -> {
            errors.addAll(r.getErrors());
            warnings.addAll(r.getWarnings());
        });

        return new GdValidationResult().withErrors(errors).withWarnings(warnings);
    }

    private GdValidationResultUtils() {}
}
