package ru.yandex.direct.grid.processing.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.regions.Region.AFRICA_REGION_ID;
import static ru.yandex.direct.regions.Region.ASIA_REGION_ID;
import static ru.yandex.direct.regions.Region.AUSTRALIA_AND_OCEANIA_REGION_ID;
import static ru.yandex.direct.regions.Region.CENTRAL_FEDERAL_DISTRICT_REGION_ID;
import static ru.yandex.direct.regions.Region.EUROPE_REGION_ID;
import static ru.yandex.direct.regions.Region.FAR_EASTERN_FEDERAL_DISTRICT_REGION_ID;
import static ru.yandex.direct.regions.Region.MOSCOW_AND_MOSCOW_PROVINCE_REGION_ID;
import static ru.yandex.direct.regions.Region.MOSCOW_REGION_ID;
import static ru.yandex.direct.regions.Region.NORTHWESTERN_FEDERAL_DISTRICT_REGION_ID;
import static ru.yandex.direct.regions.Region.NORTH_AMERICA_REGION_ID;
import static ru.yandex.direct.regions.Region.RUSSIA_REGION_ID;
import static ru.yandex.direct.regions.Region.SAINT_PETERSBURG_AND_LENINGRAD_OBLAST_REGION_ID;
import static ru.yandex.direct.regions.Region.SIBERIAN_FEDERAL_DISTRICT_REGION_ID;
import static ru.yandex.direct.regions.Region.SNG_REGION_ID;
import static ru.yandex.direct.regions.Region.SOUTH_AMERICA_REGION_ID;
import static ru.yandex.direct.regions.Region.SOUTH_FEDERAL_DISTRICT_REGION_ID;
import static ru.yandex.direct.regions.Region.VOLGA_FEDERAL_DISTRICT_REGION_ID;

@ParametersAreNonnullByDefault
class GeoTreePriorityPositions {

    // Разнообразные регионы "верхнего уровня
    // Намиксованы регионы с разным geoType, чтобы так же, как в перле.
    private static final List<Long> PRIORITY_REGION_IDS_TOP =
            List.of(RUSSIA_REGION_ID,
                    SNG_REGION_ID,
                    EUROPE_REGION_ID,
                    ASIA_REGION_ID,
                    AFRICA_REGION_ID,
                    NORTH_AMERICA_REGION_ID,
                    SOUTH_AMERICA_REGION_ID,
                    AUSTRALIA_AND_OCEANIA_REGION_ID);
    private static final List<Long> PRIORITY_REGION_IDS_RUSSIA =
            List.of(CENTRAL_FEDERAL_DISTRICT_REGION_ID,
                    NORTHWESTERN_FEDERAL_DISTRICT_REGION_ID,
                    SOUTH_FEDERAL_DISTRICT_REGION_ID,
                    VOLGA_FEDERAL_DISTRICT_REGION_ID,
                    SIBERIAN_FEDERAL_DISTRICT_REGION_ID,
                    FAR_EASTERN_FEDERAL_DISTRICT_REGION_ID);
    private static final List<Long> PRIORITY_REGION_IDS_CENTER =
            List.of(MOSCOW_AND_MOSCOW_PROVINCE_REGION_ID);
    private static final List<Long> PRIORITY_REGION_IDS_MOSCOW =
            List.of(MOSCOW_REGION_ID);
    private static final List<Long> PRIORITY_REGION_IDS_NORTHWESTERN =
            List.of(SAINT_PETERSBURG_AND_LENINGRAD_OBLAST_REGION_ID);
    private static final Map<Long, Integer> priorityPositions = new HashMap<>();

    static {
        for (List<Long> regionIds : List.of(PRIORITY_REGION_IDS_TOP,
                PRIORITY_REGION_IDS_RUSSIA,
                PRIORITY_REGION_IDS_CENTER,
                PRIORITY_REGION_IDS_MOSCOW,
                PRIORITY_REGION_IDS_NORTHWESTERN)) {
            for (int position = 0; position < regionIds.size(); position++) {
                Long regionId = regionIds.get(position);
                var previous = priorityPositions.put(regionId, position);
                checkState(previous == null,
                        String.format("Region with id %s has duplicate priority position.", regionId));
            }
        }
    }

    public static Optional<Integer> getPriorityPosition(Long regionId) {
        return Optional.ofNullable(priorityPositions.get(regionId));
    }

}
