package ru.yandex.direct.grid.processing.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.processing.service.campaign.RegionDescriptionLocalizer;
import ru.yandex.direct.regions.GeoTree;

@ParametersAreNonnullByDefault
public class GeoTreeUtils {

    @Nullable
    public static List<Long> geoToFrontendGeo(@Nullable List<Long> geo,
                                              GeoTree geoTree,
                                              RegionDescriptionLocalizer localizer) {
        if (geo == null) {
            return null;
        }
        List<Long> gdGeoExpanded = new ArrayList<>(geo);
        sortGeoForFrontend(gdGeoExpanded,
                Function.identity(),
                regionId -> localizer.localize(regionId, geoTree).getName());
        return gdGeoExpanded;
    }

    public static <T> void sortGeoForFrontend(List<T> elements,
                                              Function<T, Long> regionId,
                                              Function<T, String> regionName) {
        elements.sort(Comparator
                .comparingInt((T e) ->
                        GeoTreePriorityPositions.getPriorityPosition(regionId.apply(e)).orElse(Integer.MAX_VALUE))
                .thenComparing(regionName));
    }

}
