package ru.yandex.direct.grid.processing.util;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.grid.model.GdGoalStatsFilter;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptySet;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.mapAndFilterList;

@ParametersAreNonnullByDefault
public class GoalHelper {
    // Для статистики объединяем id целей для отображения и фильтрации
    // Так как фильтр может быть наложен на цели, которые не отображаются
    public static Set<Long> combineGoalIds(@Nullable Set<Long> goalIds,
                                           @Nullable List<GdGoalStatsFilter> goalStatsFilters) {
        List<GdGoalStatsFilter> filterGoals = nvl(goalStatsFilters, emptyList());

        return ImmutableSet.<Long>builder()
                .addAll(nvl(goalIds, emptySet()))
                .addAll(mapAndFilterList(filterGoals, GdGoalStatsFilter::getGoalId, Objects::nonNull))
                .build();
    }

}
