package ru.yandex.direct.grid.processing.util;

import java.lang.reflect.AnnotatedType;

import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;

import ru.yandex.direct.currency.Money;
import ru.yandex.direct.grid.processing.model.money.GdMoney;

/**
 * Адаптер для {@link Money}, чтобы его можно было использовать как output-тип в GraphQL схеме
 */
public class MoneyTypeAdapter extends AbstractTypeAdapter<Money, GdMoney> {

    @Override
    public GdMoney convertOutput(Money original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return new GdMoney(original);
    }

    @Override
    public Money convertInput(GdMoney substitute, AnnotatedType type, GlobalEnvironment environment,
                              ValueMapper valueMapper) {
        throw new UnsupportedOperationException("Money used as input");
    }
}

