package ru.yandex.direct.grid.processing.util;

import java.util.Collection;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.core.entity.aggregatedstatuses.AggregatedStatusBaseData;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

import static ru.yandex.direct.utils.CollectionUtils.isEmpty;

@ParametersAreNonnullByDefault
public final class ReasonsFilterUtils {
    public static <U, T extends AggregatedStatusBaseData<U>> boolean isValid(@Nullable Collection<GdSelfStatusReason> reasons, @Nullable T aggregatedStatus) {
        if (isEmpty(reasons) || aggregatedStatus == null) {
            return true;
        }

        return !CollectionUtils.intersection(reasons, aggregatedStatus.getReasons()).isEmpty();
    }
}
