package ru.yandex.direct.grid.processing.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.ToLongFunction;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import static java.math.BigDecimal.ROUND_HALF_UP;

public class StatCalculationHelper {
    private static final int SCALE = 2;
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);

    /**
     * Получить процент, который составляет число от делителя с округлением до SCALE
     * <p>
     * Если делитель равен нулю, возвращает null
     *
     * @param num     число
     * @param divider делитель
     */
    @Nullable
    public static BigDecimal percent(BigDecimal num, BigDecimal divider) {
        return ratio(num.multiply(ONE_HUNDRED), divider);
    }

    @Nullable
    public static BigDecimal percent(Long numerator, Long denominator) {
        return percent(BigDecimal.valueOf(numerator), BigDecimal.valueOf(denominator));
    }

    /**
     * Получить долю, которую составляет число от делителя с округлением до SCALE
     * <p>
     * Если делитель равен нулю, возвращает null
     *
     * @param num     число
     * @param divider делитель
     */
    @Nullable
    public static BigDecimal ratio(BigDecimal num, BigDecimal divider) {
        if (divider.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return num.divide(divider, SCALE, ROUND_HALF_UP);
    }

    public static <T> Long mapToLongAndSum(Collection<T> source, ToLongFunction<? super T> toLongMapper) {
        return StreamEx.of(source)
                .mapToLong(toLongMapper)
                .sum();
    }

    static <T> BigDecimal mapToBigDecimalAndSum(
            Collection<T> source,
            Function<? super T, BigDecimal> toBigDecimalMapper
    ) {
        return StreamEx.of(source)
                .map(toBigDecimalMapper)
                .nonNull()
                .foldLeft(BigDecimal.ZERO, BigDecimal::add);
    }
}
