package ru.yandex.direct.grid.processing.util.findandreplace;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.model.findandreplace.ChangeMode;
import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;

@ParametersAreNonnullByDefault
public class AlwaysReplaceRule implements ReplaceRule {

    private final Function<String, String> replaceFunction;

    public AlwaysReplaceRule(String changeText, ChangeMode changeMode) {
        this.replaceFunction = getReplaceFunction(changeText, changeMode);
    }

    @Override
    public String apply(String value) {
        return replaceFunction.apply(value);
    }

    private static Function<String, String> getReplaceFunction(String changeText, ChangeMode changeMode) {
        switch (changeMode) {
            case REPLACE:
                return value -> changeText;
            case PREFIX:
                return value -> value == null ? changeText : changeText + value;
            case POSTFIX:
                return value -> value == null ? changeText : value + changeText;
            default:
                throw new IllegalStateException("Unknown replace mode");
        }
    }
}
