package ru.yandex.direct.grid.processing.util.findandreplace;

import java.util.regex.Pattern;

import javax.annotation.Nullable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.grid.model.findandreplace.ChangeMode;
import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefParamsInstruction;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class BannerTurbolandingParamsReplaceRule implements ReplaceRule {

    private static final Logger logger = LoggerFactory.getLogger(BannerTurbolandingParamsReplaceRule.class);

    private final String search;
    private final String replace;
    private final ChangeMode changeMode;

    public BannerTurbolandingParamsReplaceRule(GdFindAndReplaceAdsHrefParamsInstruction instruction) {
        search = instruction.getSearchKey();
        replace = instruction.getReplaceValue();
        this.changeMode = ChangeMode.REPLACE;
    }

    public BannerTurbolandingParamsReplaceRule(@Nullable String search,
                                               @Nullable String replace,
                                               ChangeMode changeMode) {
        this.search = search;
        this.replace = replace;
        this.changeMode = changeMode;
    }

    @Override
    @Nullable
    public String apply(String value) {
        if (value == null) {
            return null;
        }

        String newQuery = replace(value, nvl(search, value), nvl(replace, ""));
        logger.debug("Old href: {}, new href: {}", value, newQuery);

        return newQuery;
    }

    private String replace(String value, String search, String replacement) {
        switch (changeMode) {
            case PREFIX:
                return value.replaceFirst(Pattern.quote(search), replacement + search);
            case POSTFIX:
                return value.replaceFirst(Pattern.quote(search), search + replacement);
            case REPLACE:
            default:
                return value.replaceFirst(Pattern.quote(search), replacement);
        }
    }
}
